% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/individual_tracer_analysis.R
\name{individual_tracer_analysis}
\alias{individual_tracer_analysis}
\title{Individual tracer analysis}
\usage{
individual_tracer_analysis(
  data,
  completion_method = "virtual",
  iter = 5000,
  seed = 123456L
)
}
\arguments{
\item{data}{A data frame containing the characteristics of sediment sources and mixtures. Users should ensure their data is in a valid format by using the `check_database()` function before running the individual tracer analysis.}

\item{completion_method}{A character string specifying the method for selecting the required remaining tracers to form a determined system of equations. Possible values are:
"virtual": Fabricate remaining tracers virtually using generated random numbers. This method is valuable for an initial assessment of the tracer's consistency without the influence of other tracers from the dataset.
"random": Randomly select remaining tracers from the dataset to complete the system. This method is useful for understanding how the tracer behaves when paired with others from the dataset.}

\item{iter}{The number of iterations for the variability analysis. Increase `iter` to improve the reliability and accuracy of the results. A sufficient number of iterations is reached when the output no longer changes significantly with further increases.}

\item{seed}{An integer used to initialize the random number generator for reproducibility.
Setting a seed ensures that the sequence of random numbers generated during the unmixing is reproducible. This is useful for debugging, testing, and comparing results across different runs.}
}
\value{
A list of data frames, where each data frame contains the predicted apportionments for a specific tracer. The last element of the list is a data frame containing the **Consistency Index (CI)** for each tracer.
}
\description{
This function computes the distribution of apportionments compatible with each individual tracer in the dataset, providing insights into the tracer's discriminant capacity and conservativeness. The method assesses the contribution of a single tracer to an unmixing model by solving a determined system of equations for each tracer.
}
\details{
The function performs an individual tracer analysis to evaluate the conservativeness and discriminant capacity of each tracer. For each tracer, it constructs a determined system of linear equations by combining it with a minimal set of other tracers.

There are two methods for completing this minimal set:
1. The **"virtual" method** fabricates the remaining tracers by randomly generating values. This approach isolates the tracer of interest from the influence of other measured tracers.
2. The **"random" method** randomly selects the remaining tracers from the available dataset, providing an assessment of how the tracer performs in combination with others.
}
\references{
Lizaga, I., Latorre, B., Gaspar, L., & Navas, A. (2020). Consensus ranking as a method to identify non-conservative and dissenting tracers in fingerprinting studies. *Science of The Total Environment*, *720*, 137537. https://doi.org/10.1016/j.scitotenv.2020.137537
}
