% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analyze_trends_over_time.R
\name{analyze_trends_over_time}
\alias{analyze_trends_over_time}
\title{Analyze Trends Over Time with Binned Years (Decades)}
\usage{
analyze_trends_over_time(data, query = "Records Over Time")
}
\arguments{
\item{data}{A tibble containing Finna search results with a \code{Year} column (as character or numeric).}

\item{query}{A search query string (optional) to label the plot.}
}
\value{
A ggplot2 plot showing the trend of records over time.
}
\description{
This function analyzes how search results for a given query have trended over time, binned by decades.
It plots the number of records found for each decade, allowing users to observe long-term trends.
}
\examples{
finna_data <- search_finna("Sibelius")
trends <- analyze_trends_over_time(finna_data, "Sibelius")
print(trends)

}
