% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/finnishgrid.R
\name{fcr_n_activated_up}
\alias{fcr_n_activated_up}
\title{Frequency Containment Reserve for Normal operation, activated up-regulation}
\usage{
fcr_n_activated_up(start_time_utc = NA, end_time_utc = NA, user_key = NA)
}
\arguments{
\item{start_time_utc}{Start time in UTC. Character array YYYY-MM-ddTHH:mm:ss.sssZ}

\item{end_time_utc}{End time in UTC. Character array YYYY-MM-ddTHH:mm:ss.sssZ}

\item{user_key}{Character array holding API-key.
Free from https://data.fingrid.fi/en/instructions}
}
\value{
A data frame object with time series data having period 15 min and unit type MW.
}
\description{
FCR-N is the frequency containment reserve used in the Nordic synchronous system that aims to keep the frequency in normal frequency range between 49,9 - 50,1 Hz. Activated FCR-N volume up (MW) is calculated on the basis of the frequency in the Nordic synchronous system and maintained Finnish FCR-N capacity. Value is the average activated up-regulation power. Positive value means that the frequency has been below 50,0 Hz during the quarter, and reserve has been activated as up-regulation.
}
\examples{
\dontrun{
library(finnishgrid)
start = "2024-06-01T00:00:00.000Z"  # UTC
end = "2024-06-03T00:00:00.000Z"    # UTC
key = "MY_SUPER_SECRET"
df <- fcr_n_activated_up(start_time_utc = start,
         end_time_utc = end,
         user_key = key)
summary(df)
}
}
\seealso{
https://data.fingrid.fi/en/datasets/344
}
