% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_related_concepts.R
\name{get_related_concepts}
\alias{get_related_concepts}
\title{Get related concepts for a specific concept from the Finto Skosmos API}
\usage{
get_related_concepts(vocid, uri, lang = NULL)
}
\arguments{
\item{vocid}{The vocabulary ID, e.g., "yso".}

\item{uri}{The URI of the concept whose related concepts to retrieve.}

\item{lang}{The language code for the labels, e.g., "fi" or "en". Optional.}
}
\value{
A tibble containing the related concepts (prefLabel and uri) for the specified concept.
}
\description{
Get related concepts for a specific concept from the Finto Skosmos API
}
\examples{
related <- get_related_concepts(vocid = "yso",
uri = "http://www.yso.fi/onto/yso/p24489", lang = "fi")
print(related)
}
