% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-ui.R
\name{FirebaseUI}
\alias{FirebaseUI}
\title{Prebuilt UI}
\value{
An object of class \code{FirebaseUI}.
}
\description{
Use firebase to manage authentications.
}
\examples{
library(shiny)
library(firebase)

ui <- fluidPage(
  useFirebase(), # import dependencies
  firebaseUIContainer() # import UI
)

server <- function(input, output){
  f <- FirebaseUI$
    new()$ # instantiate
    set_providers( # define providers
      email = TRUE, 
      google = TRUE
    )
}

\dontrun{shinyApp(ui, server)}

}
\section{Super classes}{
\code{\link[firebase:Firebase]{firebase::Firebase}} -> \code{\link[firebase:FirebaseAuth]{firebase::FirebaseAuth}} -> \code{FirebaseUI}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{tos_url}}{URL to the Terms of Service page.}

\item{\code{privacy_policy_url}}{The URL to the Privacy Policy page.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-FirebaseUI-new}{\code{FirebaseUI$new()}}
\item \href{#method-FirebaseUI-set_providers}{\code{FirebaseUI$set_providers()}}
\item \href{#method-FirebaseUI-set_tos_url}{\code{FirebaseUI$set_tos_url()}}
\item \href{#method-FirebaseUI-set_privacy_policy_url}{\code{FirebaseUI$set_privacy_policy_url()}}
\item \href{#method-FirebaseUI-launch}{\code{FirebaseUI$launch()}}
\item \href{#method-FirebaseUI-reset_password}{\code{FirebaseUI$reset_password()}}
\item \href{#method-FirebaseUI-get_reset}{\code{FirebaseUI$get_reset()}}
\item \href{#method-FirebaseUI-send_verification_email}{\code{FirebaseUI$send_verification_email()}}
\item \href{#method-FirebaseUI-get_verification_email}{\code{FirebaseUI$get_verification_email()}}
\item \href{#method-FirebaseUI-set_password}{\code{FirebaseUI$set_password()}}
\item \href{#method-FirebaseUI-get_password}{\code{FirebaseUI$get_password()}}
\item \href{#method-FirebaseUI-re_authenticate}{\code{FirebaseUI$re_authenticate()}}
\item \href{#method-FirebaseUI-get_re_authenticated}{\code{FirebaseUI$get_re_authenticated()}}
\item \href{#method-FirebaseUI-clone}{\code{FirebaseUI$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="firebase" data-topic="Firebase" data-id="expose_app"><a href='../../firebase/html/Firebase.html#method-Firebase-expose_app'><code>firebase::Firebase$expose_app()</code></a></span></li>
<li><span class="pkg-link" data-pkg="firebase" data-topic="FirebaseAuth" data-id="clear"><a href='../../firebase/html/FirebaseAuth.html#method-FirebaseAuth-clear'><code>firebase::FirebaseAuth$clear()</code></a></span></li>
<li><span class="pkg-link" data-pkg="firebase" data-topic="FirebaseAuth" data-id="delete_user"><a href='../../firebase/html/FirebaseAuth.html#method-FirebaseAuth-delete_user'><code>firebase::FirebaseAuth$delete_user()</code></a></span></li>
<li><span class="pkg-link" data-pkg="firebase" data-topic="FirebaseAuth" data-id="expose_auth"><a href='../../firebase/html/FirebaseAuth.html#method-FirebaseAuth-expose_auth'><code>firebase::FirebaseAuth$expose_auth()</code></a></span></li>
<li><span class="pkg-link" data-pkg="firebase" data-topic="FirebaseAuth" data-id="get_access_token"><a href='../../firebase/html/FirebaseAuth.html#method-FirebaseAuth-get_access_token'><code>firebase::FirebaseAuth$get_access_token()</code></a></span></li>
<li><span class="pkg-link" data-pkg="firebase" data-topic="FirebaseAuth" data-id="get_delete_user"><a href='../../firebase/html/FirebaseAuth.html#method-FirebaseAuth-get_delete_user'><code>firebase::FirebaseAuth$get_delete_user()</code></a></span></li>
<li><span class="pkg-link" data-pkg="firebase" data-topic="FirebaseAuth" data-id="get_id_token"><a href='../../firebase/html/FirebaseAuth.html#method-FirebaseAuth-get_id_token'><code>firebase::FirebaseAuth$get_id_token()</code></a></span></li>
<li><span class="pkg-link" data-pkg="firebase" data-topic="FirebaseAuth" data-id="get_sign_out"><a href='../../firebase/html/FirebaseAuth.html#method-FirebaseAuth-get_sign_out'><code>firebase::FirebaseAuth$get_sign_out()</code></a></span></li>
<li><span class="pkg-link" data-pkg="firebase" data-topic="FirebaseAuth" data-id="get_signed_in"><a href='../../firebase/html/FirebaseAuth.html#method-FirebaseAuth-get_signed_in'><code>firebase::FirebaseAuth$get_signed_in()</code></a></span></li>
<li><span class="pkg-link" data-pkg="firebase" data-topic="FirebaseAuth" data-id="get_signed_up"><a href='../../firebase/html/FirebaseAuth.html#method-FirebaseAuth-get_signed_up'><code>firebase::FirebaseAuth$get_signed_up()</code></a></span></li>
<li><span class="pkg-link" data-pkg="firebase" data-topic="FirebaseAuth" data-id="is_signed_in"><a href='../../firebase/html/FirebaseAuth.html#method-FirebaseAuth-is_signed_in'><code>firebase::FirebaseAuth$is_signed_in()</code></a></span></li>
<li><span class="pkg-link" data-pkg="firebase" data-topic="FirebaseAuth" data-id="print"><a href='../../firebase/html/FirebaseAuth.html#method-FirebaseAuth-print'><code>firebase::FirebaseAuth$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="firebase" data-topic="FirebaseAuth" data-id="req_sign_in"><a href='../../firebase/html/FirebaseAuth.html#method-FirebaseAuth-req_sign_in'><code>firebase::FirebaseAuth$req_sign_in()</code></a></span></li>
<li><span class="pkg-link" data-pkg="firebase" data-topic="FirebaseAuth" data-id="req_sign_out"><a href='../../firebase/html/FirebaseAuth.html#method-FirebaseAuth-req_sign_out'><code>firebase::FirebaseAuth$req_sign_out()</code></a></span></li>
<li><span class="pkg-link" data-pkg="firebase" data-topic="FirebaseAuth" data-id="request_id_token"><a href='../../firebase/html/FirebaseAuth.html#method-FirebaseAuth-request_id_token'><code>firebase::FirebaseAuth$request_id_token()</code></a></span></li>
<li><span class="pkg-link" data-pkg="firebase" data-topic="FirebaseAuth" data-id="set_language_code"><a href='../../firebase/html/FirebaseAuth.html#method-FirebaseAuth-set_language_code'><code>firebase::FirebaseAuth$set_language_code()</code></a></span></li>
<li><span class="pkg-link" data-pkg="firebase" data-topic="FirebaseAuth" data-id="sign_out"><a href='../../firebase/html/FirebaseAuth.html#method-FirebaseAuth-sign_out'><code>firebase::FirebaseAuth$sign_out()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FirebaseUI-new"></a>}}
\if{latex}{\out{\hypertarget{method-FirebaseUI-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FirebaseUI$new(
  persistence = c("session", "local", "memory"),
  config_path = "firebase.rds",
  language_code = NULL,
  session = shiny::getDefaultReactiveDomain()
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{persistence}}{How the auth should persit: \code{none}, the user has to sign in at every visit,
\code{session} will only persist in current tab, \code{local} persist even when window is closed.}

\item{\code{config_path}}{Path to the configuration file as created by \code{\link{firebase_config}}.}

\item{\code{language_code}}{Sets the language to use for the UI.
Supported languages are listed \href{https://github.com/firebase/firebaseui-web/blob/master/LANGUAGES.md}{here}.
Set to \code{browser} to use the default browser language of the user.}

\item{\code{session}}{A valid shiny session.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Initialiases Firebase UI

Initialises the Firebase application client-side.
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FirebaseUI-set_providers"></a>}}
\if{latex}{\out{\hypertarget{method-FirebaseUI-set_providers}{}}}
\subsection{Method \code{set_providers()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FirebaseUI$set_providers(
  google = FALSE,
  facebook = FALSE,
  twitter = FALSE,
  github = FALSE,
  email = FALSE,
  email_link = FALSE,
  microsoft = FALSE,
  apple = FALSE,
  yahoo = FALSE,
  phone = FALSE,
  anonymous = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{google, facebook, twitter, github, email, email_link, microsoft, apple, yahoo, phone, anonymous}}{Set to \code{TRUE} the providers you want to use, at least one.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Define signin and login providers.
}

\subsection{Returns}{
self
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FirebaseUI-set_tos_url"></a>}}
\if{latex}{\out{\hypertarget{method-FirebaseUI-set_tos_url}{}}}
\subsection{Method \code{set_tos_url()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FirebaseUI$set_tos_url(url)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{url}}{URL to use.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Defines Tterms of Services URL
}

\subsection{Returns}{
self
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FirebaseUI-set_privacy_policy_url"></a>}}
\if{latex}{\out{\hypertarget{method-FirebaseUI-set_privacy_policy_url}{}}}
\subsection{Method \code{set_privacy_policy_url()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FirebaseUI$set_privacy_policy_url(url)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{url}}{URL to use.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Defines Privacy Policy URL
}

\subsection{Returns}{
self
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FirebaseUI-launch"></a>}}
\if{latex}{\out{\hypertarget{method-FirebaseUI-launch}{}}}
\subsection{Method \code{launch()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FirebaseUI$launch(flow = c("popup", "redirect"), account_helper = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{flow}}{The signin flow to use, popup or redirect.}

\item{\code{account_helper}}{Wether to use accountchooser.com upon signing in or signing up with email,
the user will be redirected to the accountchooser.com website and will be able to select
one of their saved accounts. You can disable it by specifying the value below.}

\item{\code{...}}{Any other option to pass to Firebase UI.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Setup the signin form.
}

\subsection{Returns}{
self
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FirebaseUI-reset_password"></a>}}
\if{latex}{\out{\hypertarget{method-FirebaseUI-reset_password}{}}}
\subsection{Method \code{reset_password()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FirebaseUI$reset_password(email = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{email}}{Email to send reset link to, if missing looks for current logged in user's email}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Reset user password
}

\subsection{Returns}{
self
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FirebaseUI-get_reset"></a>}}
\if{latex}{\out{\hypertarget{method-FirebaseUI-get_reset}{}}}
\subsection{Method \code{get_reset()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FirebaseUI$get_reset()}\if{html}{\out{</div>}}
}

\subsection{Details}{
Get whether password reset email was successfully sent
}

\subsection{Returns}{
A list of length 2 containing \code{success} a boolean
indicating whether email reset was successful and \code{response}
containing \code{successful} or the error.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FirebaseUI-send_verification_email"></a>}}
\if{latex}{\out{\hypertarget{method-FirebaseUI-send_verification_email}{}}}
\subsection{Method \code{send_verification_email()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FirebaseUI$send_verification_email()}\if{html}{\out{</div>}}
}

\subsection{Details}{
Send the user a verification email
}

\subsection{Returns}{
self
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FirebaseUI-get_verification_email"></a>}}
\if{latex}{\out{\hypertarget{method-FirebaseUI-get_verification_email}{}}}
\subsection{Method \code{get_verification_email()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FirebaseUI$get_verification_email()}\if{html}{\out{</div>}}
}

\subsection{Details}{
Get result of verification email sending procedure
}

\subsection{Returns}{
A list of length 2 containing \code{success} a boolean
indicating whether email verification was successfully sent and \code{response}
containing \code{successful} or the error.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FirebaseUI-set_password"></a>}}
\if{latex}{\out{\hypertarget{method-FirebaseUI-set_password}{}}}
\subsection{Method \code{set_password()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FirebaseUI$set_password(password)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{password}}{The authenticated user password, the user should be prompted
to enter it.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Set user password

Useful to provide ability to change password.
}

\subsection{Returns}{
self
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FirebaseUI-get_password"></a>}}
\if{latex}{\out{\hypertarget{method-FirebaseUI-get_password}{}}}
\subsection{Method \code{get_password()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FirebaseUI$get_password()}\if{html}{\out{</div>}}
}

\subsection{Details}{
Get response from set_password
}

\subsection{Returns}{
A list of length 2 containing \code{success} a boolean
indicating whether setting password was successfully set and \code{response}
containing \code{successful} as string or the error.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FirebaseUI-re_authenticate"></a>}}
\if{latex}{\out{\hypertarget{method-FirebaseUI-re_authenticate}{}}}
\subsection{Method \code{re_authenticate()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FirebaseUI$re_authenticate(password)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{password}}{The authenticated user password, the user should be prompted
to enter it.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Re-authenticate the user.

Some security-sensitive actions—such as deleting an account, setting a
primary email address, and changing a password—require that the user has
recently signed in. If you perform one of these actions, and the user signed
in too long ago, the action fails with an error.
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FirebaseUI-get_re_authenticated"></a>}}
\if{latex}{\out{\hypertarget{method-FirebaseUI-get_re_authenticated}{}}}
\subsection{Method \code{get_re_authenticated()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FirebaseUI$get_re_authenticated()}\if{html}{\out{</div>}}
}

\subsection{Details}{
Get response from re_authenticate
}

\subsection{Returns}{
A list of length 2 containing \code{success} a boolean
indicating whether re-authentication was successful and \code{response}
containing \code{successful} as string or the error.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FirebaseUI-clone"></a>}}
\if{latex}{\out{\hypertarget{method-FirebaseUI-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FirebaseUI$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
