% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/event_study.R
\name{run_es}
\alias{run_es}
\title{Event Study Estimation for Panel Data}
\usage{
run_es(
  data,
  outcome,
  treatment,
  time,
  timing,
  fe,
  lead_range = NULL,
  lag_range = NULL,
  covariates = NULL,
  cluster = NULL,
  weights = NULL,
  baseline = -1,
  interval = 1,
  time_transform = FALSE,
  unit = NULL,
  staggered = FALSE,
  conf.level = 0.95
)
}
\arguments{
\item{data}{A data.frame with panel data. Must contain all required variables.}

\item{outcome}{Outcome variable (unquoted variable name or expression, e.g. \code{log(y)}).}

\item{treatment}{Treatment indicator (unquoted; 0/1 or logical).}

\item{time}{Time variable (unquoted; numeric or Date).}

\item{timing}{Treatment timing: a numeric or Date for universal timing, or a variable (unquoted) for staggered.}

\item{fe}{One-sided formula for fixed effects (e.g. \code{~ id + year}).}

\item{lead_range}{Number of pre-treatment periods to include (default: detected from data).}

\item{lag_range}{Number of post-treatment periods to include (default: detected from data).}

\item{covariates}{One-sided formula of additional controls (optional).}

\item{cluster}{Cluster variable(s), as a one-sided formula or character vector (optional).}

\item{weights}{Observation weights (formula, character, or unquoted variable).}

\item{baseline}{Baseline period for normalization (default: -1, i.e., one period before treatment).}

\item{interval}{Numeric; interval of the time variable (default: 1).}

\item{time_transform}{Logical; if \code{TRUE}, converts time variable to consecutive integer within units (requires \code{unit}).}

\item{unit}{Panel unit variable (required if \code{time_transform = TRUE}).}

\item{staggered}{Logical; if \code{TRUE}, treats timing as variable (default: \code{FALSE}).}

\item{conf.level}{Numeric vector of confidence levels (e.g. \code{c(0.90, 0.95, 0.99)}; default: \code{0.95}).}
}
\value{
A data.frame with class \code{"es_result"}, containing:
\describe{
  \item{term}{Dummy variable name (\code{leadX}, \code{lagY})}
  \item{estimate, std.error, statistic, p.value}{Coefficient estimates, standard errors, test statistics, and p-values}
  \item{conf_low_XX, conf_high_XX}{Confidence intervals at each requested level}
  \item{relative_time}{Period relative to treatment (0 = event)}
  \item{is_baseline}{Logical, is this the baseline period (estimate always 0)}
}
Attributes: \code{lead_range}, \code{lag_range}, \code{baseline}, \code{interval}, \code{call}, \code{model_formula}, \code{conf.level}.
}
\description{
\code{run_es()} is a user-friendly event study wrapper for panel data, supporting both classic (universal timing) and staggered (unit-varying timing) settings. It generates lead/lag dummy variables around treatment, builds the regression formula, and returns tidy results with confidence intervals for arbitrary levels.
}
\details{
Runs an event study regression on panel data, automatically generating lead/lag dummies around a treatment event.


The function does not require explicit formula specification; dummy variables and model formula are constructed internally.
Baseline normalization (reference category) can be customized. Untreated units or units never treated are supported.
Missing values in key variables result in an error.
}
\section{Key Features}{

\itemize{
  \item One-step event study: specify outcome, treatment, time, timing, and fixed effects directly.
  \item Supports both universal and staggered treatment timing.
  \item Flexible covariate, clustering, and weighting options.
  \item Customizable lead/lag window and baseline normalization.
  \item Returns a tidy \code{data.frame} (class \code{"es_result"}) with estimates and confidence intervals.
}
}

\examples{
\dontrun{
# Simulated example
result <- run_es(
  data       = panel_data,
  outcome    = y,
  treatment  = treated_1998,
  time       = year,
  timing     = 1998,
  fe         = ~ firm_id + year,
  cluster    = ~ state_id,
  lead_range = 3,
  lag_range  = 3,
  conf.level = c(0.90, 0.95, 0.99)
)
plot_es(result)
}

}
\seealso{
\code{\link{plot_es}}
}
\author{
Yosuke Abe
}
