% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sparse_model_matrix.R
\name{sparse_model_matrix}
\alias{sparse_model_matrix}
\title{Design matrix of a \code{fixest} object returned in sparse format}
\usage{
sparse_model_matrix(
  object,
  data,
  type = "rhs",
  sample = "estimation",
  na.rm = FALSE,
  collin.rm = NULL,
  combine = TRUE,
  ...
)
}
\arguments{
\item{object}{A \code{fixest} object. Obtained using the functions \code{\link{femlm}}, \code{\link{feols}} or \code{\link{feglm}}.}

\item{data}{If missing (default) then the original data is obtained by evaluating the \code{call}.
Otherwise, it should be a \code{data.frame}.}

\item{type}{Character vector or one sided formula, default is "rhs".
Contains the type of matrix/data.frame to be returned. Possible values are:
"lhs", "rhs", "fixef", "iv.rhs1" (1st stage RHS), "iv.rhs2" (2nd stage RHS),
"iv.endo" (endogenous vars.), "iv.exo" (exogenous vars), "iv.inst" (instruments).}

\item{sample}{Character scalar equal to "estimation" (default) or "original". Only
used when \code{data=NULL} (i.e. the original data is requested). By default,
only the observations effectively used in the estimation are returned (it includes
the observations with NA values or the fully explained by the fixed-effects (FE), or
due to NAs in the weights).

If \code{sample="original"}, all the observations are returned. In that case, if
you use \code{na.rm=TRUE} (which is not the default), you can withdraw the observations
with NA values (and keep the ones fully explained by the FEs).}

\item{na.rm}{Default is \code{FALSE}. Should observations with NAs be removed from the matrix?}

\item{collin.rm}{Logical scalar. Whether to remove variables that were
found to be collinear during the estimation. Beware: it does not perform a
collinearity check and bases on the \code{coef(object)}.
Default is TRUE if object is a \code{fixest} object, or \code{FALSE} if object is a formula.}

\item{combine}{Logical scalar, default is \code{TRUE}. Whether to combine each
resulting sparse matrix.}

\item{...}{Not currently used.}
}
\value{
It returns either a single sparse matrix a list of matrices,
depending whether \code{combine} is \code{TRUE} or \code{FALSE}.
The sparse matrix is of class \code{dgCMatrix} from the \code{Matrix} package.
}
\description{
This function creates the left-hand-side or the right-hand-side(s) of a \code{\link{femlm}}, \code{\link{feols}} or \code{\link{feglm}} estimation.
}
\examples{

est = feols(wt ~ i(vs) + hp | cyl, mtcars)
sparse_model_matrix(est)
sparse_model_matrix(wt ~ i(vs) + hp | cyl, mtcars)

}
\seealso{
See also the main estimation functions \code{\link{femlm}}, \code{\link{feols}} or \code{\link{feglm}}. \code{\link{formula.fixest}}, \code{\link{update.fixest}}, \code{\link{summary.fixest}}, \code{\link{vcov.fixest}}.
}
\author{
Laurent Berge, Kyle Butts
}
