% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{residuals.flashlight}
\alias{residuals.flashlight}
\title{Residuals for flashlight}
\usage{
\method{residuals}{flashlight}(object, ...)
}
\arguments{
\item{object}{An object of class "flashlight".}

\item{...}{Arguments used to update the flashlight before calculating the residuals.}
}
\value{
A numeric vector with residuals.
}
\description{
Residuals method for an object of class "flashlight".
Pass additional elements to update the flashlight before calculation of residuals.
}
\examples{
fit <- lm(Sepal.Length ~ ., data = iris)
x <- flashlight(model = fit, data = iris, y = "Sepal.Length", label = "ols")
residuals(x)[1:5]
}
