% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{myAIC}
\alias{myAIC}
\title{Calculate Akaike Information Criterion (AIC)}
\usage{
myAIC(LL, nparam)
}
\arguments{
\item{LL}{Numeric value representing the log-likelihood of the model.}

\item{nparam}{Numeric value representing the number of parameters in the
model.}
}
\value{
Numeric value representing the AIC.
}
\description{
This function calculates the Akaike Information Criterion (AIC) for a given
model.
}
\details{
The AIC is calculated using the formula:
\deqn{AIC = -2 \cdot LL + 2 \cdot nparam}
Where \eqn{LL} is the log-likelihood of the model and \eqn{nparam} is the
number of parameters.
}
\examples{
LL <- -120.5
nparam <- 5
myAIC(LL, nparam)

}
