% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flexIC.R
\name{flexIC}
\alias{flexIC}
\title{flexIC: Tunable Iman–Conover Rank-Correlation Imposition}
\usage{
flexIC(x, target_r, eps = "none", max_iter = 20)
}
\arguments{
\item{x}{Numeric matrix or data frame. Columns should be independent prior to transformation.}

\item{target_r}{Target Spearman correlation matrix to impose. Must be square, symmetric, and positive-definite.}

\item{eps}{Convergence tolerance (maximum absolute deviation allowed between achieved and target Spearman correlation).
If \code{eps = "none"}, no convergence test is performed and the first draw is used (equivalent to classic Iman–Conover).}

\item{max_iter}{Maximum number of candidate draws to evaluate when \code{eps} is numeric.}
}
\value{
A numeric matrix with same dimensions as \code{x}, with transformed columns preserving marginal distributions
and approximately matching the specified rank correlation structure.
}
\description{
Applies a rank-based correlation structure to a numeric matrix using
a flexible, iterative variant of the Iman–Conover algorithm.
The method reorders each column of \code{x} based on the rank structure
of a multivariate normal draw whose correlation matrix matches \code{target_r}.
If \code{eps} is specified, the algorithm will iteratively draw candidates and
select the one with the closest match to the target Spearman structure.
The marginal distributions of \code{x} are preserved exactly.
}
\examples{
set.seed(1)
x <- cbind(rexp(100), rbinom(100, 5, 0.4))
R_target <- matrix(c(1, 0.6, 0.6, 1), 2)
out <- flexIC(x, R_target, eps = 0.02, max_iter = 50)
cor(out, method = "spearman")

}
