% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fuzzy_operations.R
\name{fuzzy_crisp_mult}
\alias{fuzzy_crisp_mult}
\title{Multiply a crisp scalar by a triangular fuzzy number}
\usage{
fuzzy_crisp_mult(scalar, fuzzy_num)
}
\arguments{
\item{scalar}{Numeric. The scalar to multiply with the fuzzy number.}

\item{fuzzy_num}{List. A triangular fuzzy number with components \code{l}, \code{x}, and \code{r}.}
}
\value{
A list representing the scaled fuzzy number.
}
\description{
Scales a triangular fuzzy number by a crisp scalar.
}
\examples{
scalar <- 3
fuzzy_num <- list(l = 1, x = 2, r = 3)
fuzzy_crisp_mult(scalar, fuzzy_num)
}
