% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regional_evi.R
\name{RegioWeissman}
\alias{RegioWeissman}
\title{Quantile estimation: Weissman's extrapolation}
\usage{
RegioWeissman(x, j = 1, p, k, k.qu = 20, type = "evopt", alpha = 0.05)
}
\arguments{
\item{x}{Vector or matrix of observations}

\item{j}{The number of the target site, i.e., if \code{j=2} the p-quantile of the second column of \code{x} is estimated.}

\item{p}{The probability of interest; should be between \eqn{1-k_j/n_j} and 1, where \eqn{n_j} is the sample length of the j-th column.}

\item{k}{Number of relative excesses involved in the estimation of the extreme value
index gamma. If \code{k} is missing, it will be set to \itemize{
 \item \eqn{k=\left\lfloor 2n^{2/3}\right\rfloor}{k=floor(2*n^(2/3))}, where n is the
sample length of the vector \code{x} after removing missing values
 \item \eqn{k=\left\lfloor \frac{2n^{2/3}}{d^{1/3}}\right\rfloor}{k=floor(2*n^(2/3)/d^(1/3))}, where d is the number of
 columns of the matrix \code{x} and n the length of each column after removing missing values.}}

\item{k.qu}{Tuning parameter for estimation of empirical variance; only needed if \code{type="opt"}.}

\item{type}{Choose either \code{"evopt"} if extreme value dependent, \code{"ind"} if independent or \code{"opt"} for arbitrarily dependent components.}

\item{alpha}{Confidence level for confidence interval.}
}
\value{
List of \itemize{
 \item \code{est} Point estimate of p-quantile of column j
 \item \code{CI} the corresponding alpha-confidence interval
 \item \code{EVI} estimate of the extreme value index
 \item \code{k} tail sample size
 \item \code{p} a probability
 \item \code{u.kn} (n-k)-th largest observation, where n is the sample length at station j after removing missing values
 \item \code{description} a short description.}
}
\description{
Estimation of the p-quantile based on multiple local Hill estimators and Weissman's extrapolation formula. We assume heavy-tail homogeneity, i.e., all local EVI's are the same.
}
\examples{
library("evd")
# sample observations of 75 years at one station:
x <- rgev(75, 0, 1, 0) # x is a vector
RegioWeissman(x=x, p=0.95)

x2 <- c(NA, NA, x[1:60], NA, x[61:75]) # vector of observations with missing values
RegioWeissman(x=x2, p=0.95) # NAs will be removed

# sample observations of 100 years at 4 stations:
set.seed(1053)
x <- matrix(rgev(400, 2, 1, 0.3), ncol=4)
RegioWeissman(x=x, p=0.9, j=3)

# With missing values:
x2 <- x
x2[sample(100, 12),2] <- NA
RegioWeissman(x=x2, p=0.9, j=3)
}

