% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_fc.R
\name{as_fc}
\alias{as_fc}
\title{as_fc}
\usage{
as_fc(
  .data = NULL,
  N = NULL,
  label = "Initial dataframe",
  text_pattern = "{label}\\n{N}",
  just = "center",
  text_color = "black",
  text_fs = 8,
  text_fface = 1,
  text_ffamily = NA,
  text_padding = 1,
  bg_fill = "white",
  border_color = "black",
  width = NA,
  height = NA,
  hide = FALSE,
  title = NULL,
  x_title = 0.1,
  text_color_title = "black",
  text_fs_title = 10,
  text_fface_title = 1,
  text_ffamily_title = NA,
  text_padding_title = 0.6,
  bg_fill_title = "#B3D1FF",
  border_color_title = "black",
  width_title = NA,
  height_title = NA
)
}
\arguments{
\item{.data}{Data frame to be initialised as a flowchart.}

\item{N}{Number of rows of the study in case \code{.data} is \code{NULL}.}

\item{label}{Character or expression with the text that will be shown in the box.}

\item{text_pattern}{Character or expression defining the structure that will have the text in each of the boxes. It recognizes \code{label}, \code{n}, \code{N} and \code{perc} within brackets. For default it is \code{"{label}\\n {n}"}. If \code{text_pattern} or \code{label} is an expression, the \code{label} is always placed at the beginning of the pattern, followed by a line break where the structure specified by \code{text_pattern} is placed.}

\item{just}{Justification for the text: left, center or right. Default is center.}

\item{text_color}{Color of the text. It is \code{"black"} by default. See the \code{col} parameter for \link{gpar}.}

\item{text_fs}{Font size of the text. It is 8 by default. See the \code{fontsize} parameter for \link{gpar}.}

\item{text_fface}{Font face of the text. It is 1 by default. See the \code{fontface} parameter for \link{gpar}.}

\item{text_ffamily}{Changes the font family of the text. Default is \code{NA}. See the \code{fontfamily} parameter for \link{gpar}.}

\item{text_padding}{Changes the text padding inside the box. Default is 1. This number has to be greater than 0.}

\item{bg_fill}{Box background color. It is white by default. See the \code{fill} parameter for \link{gpar}.}

\item{border_color}{Box border color. It is \code{"black"} by default. See the \code{col} parameter for \link{gpar}.}

\item{width}{Width of the box. If \code{NA}, it automatically adjusts to the content (default). Must be an object of class \link{unit} or a number between 0 and 1.}

\item{height}{Height of the box. If \code{NA}, it automatically adjusts to the content (default). Must be an object of class \link{unit} or a number between 0 and 1.}

\item{hide}{Logical value to hide the initial box or not. Default is FALSE. hide = TRUE can only be combined with \code{\link[=fc_split]{fc_split()}}.}

\item{title}{Add a title box to the initial box. Default is \code{NULL}.}

\item{x_title}{x-coordinate of the title box. Default is \code{0.1} (placed in the left).}

\item{text_color_title}{Color of the title text. It is \code{"black"} by default.}

\item{text_fs_title}{Font size of the title text. It is 8 by default.}

\item{text_fface_title}{Font face of the title text. It is 1 by default. See the \code{fontface} parameter for \link{gpar}.}

\item{text_ffamily_title}{Changes the font family of the title text. Default is \code{NA}. See the \code{fontfamily} parameter for \link{gpar}.}

\item{text_padding_title}{Changes the title text padding inside the box. Default is 1. This number has to be greater than 0.}

\item{bg_fill_title}{Title box background color. It is \code{"white"} by default.}

\item{border_color_title}{Title box border color. It is \code{"black"} by default.}

\item{width_title}{Width of the title box. If \code{NA}, it automatically adjusts to the content (default). Must be an object of class \link{unit} or a number between 0 and 1.}

\item{height_title}{Height of the title box. If \code{NA}, it automatically adjusts to the content (default). Must be an object of class \link{unit} or a number between 0 and 1.}
}
\value{
List with the dataset and the initialized flowchart parameters.
}
\description{
This function allows to initialize a flow chart given any database. It will create a fc object showing the number of rows of the database. If a database is not available, the user can instead directly enter the number of rows in the study.
}
\examples{
safo |>
as_fc(label = "Patients assessed for eligibility") |>
fc_draw()

}
