% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kernel.R
\name{plan_update_sequence}
\alias{plan_update_sequence}
\title{Parameters' update sequence}
\usage{
plan_update_sequence(k, nsteps, fixed, scheme)
}
\arguments{
\item{k}{Integer. Number of parameters}

\item{nsteps}{Integer. Number of steps.}

\item{fixed}{Logical scalar or vector of length \code{k}. Indicates which parameters
will be treated as fixed or not. Single values are recycled.}

\item{scheme}{Scheme in which the proposals are made (see details).}
}
\value{
A logical vector of size \code{nsteps} x \code{k}.
}
\description{
Parameters' update sequence
}
\details{
The parameter \code{scheme} present on the currently available kernels sets the way
in which proposals are made. By default, \code{scheme = "joint"}, proposals are done
jointly, this is, at each step of the chain we are proposing new states for
each parameter of the model. When \code{scheme = "ordered"}, a sequential update schema
is followed, in which, at each step of the chain, proposals are made one
variable at a time, If \code{scheme = "random"}, proposals are also made one
variable at a time but in a random scheme.

Finally, users can specify their own sequence of proposals for the variables
by passing a numeric vector to \code{scheme}, for example, if the user wants to make
sequential proposals following the scheme 2, 1, 3, then scheme must be set to
be \code{scheme = c(2, 1, 3)}.
}
