% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/integration.R
\name{new_fm_int}
\alias{new_fm_int}
\title{Construct integration scheme objects}
\usage{
new_fm_int(
  object,
  blocks = FALSE,
  weight = NULL,
  name = NULL,
  override = FALSE
)
}
\arguments{
\item{object}{An object representing integration points; either a
data.frame-like object, or a vector/list of coordinates or other location
reference objects.}

\item{blocks}{logical; if \code{TRUE}, set per-element \code{.block} indices.
If \code{FALSE} (default), set a common block, \code{1L}.}

\item{weight}{Optional weight variable; if \code{NULL}, all weights are set to 1.}

\item{name}{character; name of the integration domain.}

\item{override}{logical; If \code{name} is non-NULL and \code{override=TRUE} for sf
object, the current \code{sf_column} is renamed to \code{name}.}
}
\value{
A tibble or sf/tibble object. May acquire additional class
attributes in the future.
}
\description{
Constructor method for integration scheme objects, allowing
default construction of \code{.block} information. Primarily meant for internal
use, but can be used to manually create data of the same structure as
\code{\link[=fm_int]{fm_int()}} output.
}
\examples{
new_fm_int(1:4, blocks = TRUE, weight = c(1, 2, 1, 3), name = "z")
}
\seealso{
\code{\link[=fm_int]{fm_int()}}
}
