% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/components.R
\name{fm_components}
\alias{fm_components}
\alias{fm_components.fm_mesh_2d}
\alias{fm_components.fm_mesh_3d}
\alias{fm_components.fm_segm}
\alias{fm_components.fm_segm_list}
\title{Compute connected mesh subsets}
\usage{
fm_components(x, ...)

\method{fm_components}{fm_mesh_2d}(x, ...)

\method{fm_components}{fm_mesh_3d}(x, ...)

\method{fm_components}{fm_segm}(x, ...)

\method{fm_components}{fm_segm_list}(x, ...)
}
\arguments{
\item{x}{An object to extract components from}

\item{...}{Additional arguments passed to methods}
}
\value{
For \code{fm_mesh_2d} and \code{fm_mesh_3d}, returns a list with elements
\code{vertex} and \code{triangle}/\code{tetra}, vectors of
integer labels for which connected component they belong, and \code{info}, a
\code{data.frame} with columns
\item{component}{Connected component integer label.}
\item{nV}{The number of vertices in the component.}
\item{nT}{The number of triangles/tetrahedrons in the component.}
\item{area/volume}{The surface area or volume associated with the component.
Component labels are not comparable across
different meshes, but some ordering stability is guaranteed by initiating
each component from the lowest numbered triangle whenever a new component is
initiated.}

For \code{fm_segm}, returns a list of segments, each with component
either a single closed loop of segments, or an open segment chain.
}
\description{
Compute subsets of vertices and triangles/tetrahedrons in an
\link{fm_mesh_2d} or \link{fm_mesh_3d} object that are connected by edges/triangles,
and split \link{fm_segm} objects into connected components.
}
\examples{

# Construct two simple meshes:
loc <- matrix(c(0, 1, 0, 1), 2, 2)
mesh1 <- fm_mesh_2d(loc = loc, max.edge = 0.1)
bnd <- fm_nonconvex_hull(loc, 0.3)
mesh2 <- fm_mesh_2d(boundary = bnd, max.edge = 0.1)

# Compute connectivity information:
conn1 <- fm_components(mesh1)
conn2 <- fm_components(mesh2)
# One component, simply connected mesh
conn1$info
# Two disconnected components
conn2$info

# Extract the subset mesh for each component:
# (Note: some information is lost, such as fixed segments,
# and boundary edge labels.)
mesh3_1 <- fm_rcdt_2d_inla(
  loc = mesh2$loc,
  tv = mesh2$graph$tv[conn2$triangle == 1, , drop = FALSE],
  delaunay = FALSE
)
mesh3_2 <- fm_rcdt_2d_inla(
  loc = mesh2$loc,
  tv = mesh2$graph$tv[conn2$triangle == 2, , drop = FALSE],
  delaunay = FALSE
)

if (require("ggplot2")) {
  ggplot() +
    geom_fm(data = mesh3_1, fill = "red", alpha = 0.5) +
    geom_fm(data = mesh3_2, fill = "blue", alpha = 0.5)
}

(m <- fm_mesh_3d(
  matrix(c(1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0), 4, 3, byrow = TRUE),
  matrix(c(1, 2, 3, 4), 1, 4, byrow = TRUE)
))
# Compute connectivity information:
(conn <- fm_components(m))

(segm <- c(
  fm_segm(
    matrix(c(0, 0, 1, 0, 1, 1, 0, 1), 4, 2, byrow = TRUE),
    matrix(c(1, 2, 2, 3, 3, 4, 4, 1), 4, 2, byrow = TRUE)
  ),
  fm_segm(
    matrix(c(0, 0, 1, 0, 1, 1, 0, 1), 4, 2, byrow = TRUE),
    matrix(c(3, 4, 1, 2, 2, 3), 3, 2, byrow = TRUE),
    is.bnd = FALSE
  )
))
# Compute connectivity information:
(conn <- lapply(segm, fm_components))
(conn2 <- fm_components(segm))
}
\seealso{
\code{\link[=fm_mesh_2d]{fm_mesh_2d()}}, \code{\link[=fm_rcdt_2d]{fm_rcdt_2d()}}, \code{\link[=fm_mesh_3d]{fm_mesh_3d()}}, \code{\link[=fm_segm]{fm_segm()}}
}
\author{
Finn Lindgren \href{mailto:Finn.Lindgren@gmail.com}{Finn.Lindgren@gmail.com}
}
