% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fmi_functions.R
\name{compare_latent_means}
\alias{compare_latent_means}
\title{Compare Latent Means}
\usage{
compare_latent_means(fmi_results, group_vec)
}
\arguments{
\item{fmi_results}{The list object returned by \code{run_fmi()}.}

\item{group_vec}{The original group vector used in \code{run_fmi()}.}
}
\value{
A tibble summarizing the t-test results for each FPC.
}
\description{
Performs Welch's t-tests on FPC scores between groups.
This function should only be run after scalar invariance is established.
}
\examples{
\donttest{
  sim <- simulate_fmi_data(N_A = 20, N_B = 20, T_points = 30)
  fmi_results <- run_fmi(
    Y_mat = sim$Y_mat,
    group_vec = sim$group_vec,
    argvals = sim$argvals,
    n_perms = 9,
    progress = FALSE
  )
  # This will run only if scalar invariance passed
  if (!is.null(fmi_results$scalar) && fmi_results$scalar$passed) {
    mean_results <- compare_latent_means(fmi_results, sim$group_vec)
    print(mean_results)
  }
}
}
