% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/holdings.R
\name{fmpc_holdings_etf}
\alias{fmpc_holdings_etf}
\title{Pull ETF holdings data}
\usage{
fmpc_holdings_etf(etfs = c("SPY"), holding = c("symbol", "sector", "country"))
}
\arguments{
\item{etfs}{one or more valid ETFs.}

\item{holding}{holding type can be other individual symbols, the sector
breakdown, or the country breakdown. Valid inputs include 'symbol',
'sector', 'country'}
}
\value{
data frame of mutual fund holdings
}
\description{
Shows holdings data for one or more ETFs provided. Either individual
holdings, sector weightings, or country weightings.
}
\details{
This differs from \code{\link{fmpc_held_by_mfs}} which allows a search by
symbol to see the mutual funds holding the specified symbol(s). This function
searches by ETF and shows the holding of the ETF
}
\examples{

\dontrun{

 # For multiple symbols, set a valid API Token
 fmpc_set_token('FMPAPIKEY')
 fmpc_holdings_etf(c('VOO','SPY'), holding = 'symbol')
 fmpc_holdings_etf(c('VOO','SPY'), holding = 'country')
 fmpc_holdings_etf(c('VOO','SPY'), holding = 'sector')

 }

}
