% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_generic.R, R/reg-methods.R
\name{amplitudes}
\alias{amplitudes}
\alias{amplitudes.Reg}
\title{Get amplitudes from an object}
\usage{
amplitudes(x, ...)

\method{amplitudes}{Reg}(x, ...)
}
\arguments{
\item{x}{Object containing amplitude information}

\item{...}{Additional arguments passed to methods}
}
\value{
Numeric vector of amplitudes
}
\description{
Generic accessor returning event amplitudes or scaling factors.
}
\examples{
# Create a regressor with varying amplitudes
reg <- regressor(onsets = c(1, 5, 10), hrf = HRF_SPMG1,
                 amplitude = c(1, 0.5, 2), 
                 span = 20)
amplitudes(reg)
}
