% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_generic.R, R/sampling_frame.R
\name{global_onsets}
\alias{global_onsets}
\alias{global_onsets.sampling_frame}
\title{Convert onsets to global timing}
\usage{
global_onsets(x, ...)

\method{global_onsets}{sampling_frame}(x, onsets, blockids, ...)
}
\arguments{
\item{x}{Object describing the sampling frame}

\item{...}{Additional arguments passed to methods}

\item{onsets}{Numeric vector of onset times within blocks}

\item{blockids}{Integer vector identifying the block for each onset. Values
must be whole numbers with no NAs.}
}
\value{
Numeric vector of global onset times
}
\description{
Generic accessor for converting block-wise onsets to global onsets.
}
\examples{
# Convert block-relative onsets to global timing
sframe <- sampling_frame(blocklens = c(100, 120), TR = 2)
global_onsets(sframe, onsets = c(10, 20), blockids = c(1, 2))
}
