% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{which0}
\alias{which0}
\title{Matrix Which Function}
\usage{
which0(X, f)
}
\arguments{
\item{X}{A matrix}

\item{f}{A predicate to apply to each element of \eqn{X}.}
}
\value{
A matrix with two columns. Each row contains a row and column index
corresponding to an element of \eqn{X} that matches the criteria of \eqn{f}.
See section "Which" of the package vignette for details.
}
\description{
Matrix Which Function
}
\details{
The \code{which} C++ functions are intended to operate like the following call
in R.

\if{html}{\out{<div class="sourceCode">}}\preformatted{which(f(X), arr.ind = TRUE) - 1
}\if{html}{\out{</div>}}

The R functions exposed here are specific to numeric-valued matrices, but
the underlying C++ functions are intended to work with any type of Rcpp
Matrix.
}
\examples{
X = matrix(1:12 / 6, nrow = 4, ncol = 3)
f = function(x) { x < 1 }
which0(X, f)

}
