% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_by_ocean.R
\name{filter_by_ocean}
\alias{filter_by_ocean}
\title{Filter FORCIS data by ocean}
\usage{
filter_by_ocean(data, ocean)
}
\arguments{
\item{data}{a \code{tibble} or a \code{data.frame}. One obtained by \verb{read_*_data()}
functions.}

\item{ocean}{a \code{character} vector of one or several ocean names. Use the
function \code{get_ocean_names()} to find the correct spelling.}
}
\value{
A \code{tibble} containing a subset of \code{data} for the desired oceans.
}
\description{
Filters FORCIS data by one or several oceans.
}
\examples{
# Import example dataset ----
file_name <- system.file(file.path("extdata", "FORCIS_net_sample.csv"),
                         package = "forcis")

net_data <- read.csv(file_name)

# Dimensions of the data.frame ----
dim(net_data)

# Get ocean names ----
get_ocean_names()

# Filter by oceans ----
net_data_sub <- filter_by_ocean(net_data, ocean = "Indian Ocean")

# Dimensions of the data.frame ----
dim(net_data_sub)
}
