% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/densify.R
\name{densify}
\alias{densify}
\title{densify}
\usage{
densify(
  x,
  rank = "genus",
  srt = "max_ma",
  end = "min_ma",
  step = 1,
  density = 0.1,
  method = c("histogram", "kernel"),
  ...,
  verbose = TRUE
)
}
\arguments{
\item{x}{An occurrence dataset}

\item{rank}{The column name in x containing the taxon names
for which densified columns will be generated}

\item{srt}{A column name in x denoting the occurrence FADs}

\item{end}{A column name in x denoting the occurrence LADs}

\item{step}{A positive integer specifying the time window size
(i.e. the duration represented by each row in the output matrix)}

\item{density}{A positive numeric specifying the step size for
densifying records. This should ideally be smaller than step}

\item{method}{The method for quantifying occurrence density. By
default both histogram and kernel density will be used}

\item{...}{additional arguments passed to @seealso density}

\item{verbose}{A logical determining if function progress
should be reported}
}
\value{
A list of two sparse matrices, the first containing
the histogram counts, the second the kernel density estimates
}
\description{
Function to create a matrix of occurrence record densities
through geological time from an occurrence dataset. Each column
represents a taxon. Each row represents a user defined window of
time, with the first row starting at the oldest FAD in the
dataset and spanning to the youngest LAD stepwise by the user
defined window (default of 1 Ma). Occurrence records are
densified by generating a vector of time points from occurrence
FAD to occurrence LAD (default step of 0.1 Ma), then tallied in
two ways. The first way is a simple histogram count of
points-per-window, with the same number of histogram bins as time
steps between the overall taxon FAD and LAD. The second way is a
kernel density estimate, using a Gaussian kernel with a equally
spaced estimatopms equal to the number of timesteps between the
overall taxon FAD and LAD
}
\examples{
# load dataset
data("brachios")
# subsample brachios to make for a short example runtime
set.seed(1)
brachios <- brachios[sample(1:nrow(brachios), 1000),]
# densify ranges
dens <- densify(brachios)
}
