% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/threshold_peaks.R
\name{threshold_peaks}
\alias{threshold_peaks}
\title{threshold_peaks}
\usage{
threshold_peaks(
  x,
  y,
  ycols = c("genus", "max_ma", "min_ma"),
  thresh = 15,
  verbose = TRUE
)
}
\arguments{
\item{x}{A list of significant peaks as returned by \code{find_peaks}}

\item{y}{An occurrence dataset with taxon names corresponding
to the list names of x}

\item{ycols}{A character vector denoting, in order, the taxon, FAD
and LAD columns in y}

\item{thresh}{The threshold distance between peaks above which
they will be considered distinct - given in Ma}

\item{verbose}{A logical determining if function progress
should be reported}
}
\description{
Function to detect if two peaks in a density spectrum can
be considered separate based on a user supplied threshold.
Creates a sequence of divisions from the troughs immediately
preceding any significant peaks, then bins occurrences for
a given taxon name by those divisions.
}
