% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{trap_roc}
\alias{trap_roc}
\title{Calculate Area Under Curve (AUC) using trapezoidal rule}
\usage{
trap_roc(x, y)
}
\arguments{
\item{x}{Numeric vector (arma::vec) of x-coordinates (should be sorted in increasing order)}

\item{y}{Numeric vector (arma::vec) of y-coordinates corresponding to x-coordinates}
}
\value{
A numerical value representing the computed area under the curve as a double precision value.
}
\description{
Computes the area under a curve using the trapezoidal rule of numerical integration.
}
\details{
The trapezoidal rule approximates the area under the curve by dividing it into trapezoids.
For each pair of adjacent points (x[i], y[i]) and (x[i+1], y[i+1]), it calculates the area of the trapezoid formed.
The total AUC is the sum of all these individual trapezoid areas.

Special cases:
- Returns 0 if there are fewer than 2 points (no area can be calculated)
- Handles both increasing and decreasing x values (though typically x should be increasing for ROC curves)
}
\examples{
# R code example:
x <- c(0, 0.5, 1, 1.5, 2)
y <- c(0, 0.7, 0.9, 0.95, 1)
trap_roc(x, y)

}
\seealso{
\code{\link{integrate}} for R's built-in integration functions
}
