% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ObjCov.R
\name{ObjCov}
\alias{ObjCov}
\title{Object Covariance}
\usage{
ObjCov(tgrid, I, K, smooth = TRUE)
}
\arguments{
\item{tgrid}{Time grid for the time varying object data and covariance function}

\item{I}{A four dimension array of \code{n} x \code{n} matrix of squared distances between the time point u of the ith process and process and the time point v of the jth object process, 
e.g.: \eqn{I[i,j,u,v] = d^2(X_i(u) X_j(v))}}

\item{K}{Numbers of principal components}

\item{smooth}{Logical indicating if the smoothing is enabled when calculating the eigenvalues and eigenfunctions}
}
\value{
A list of the following:
\item{C}{Estimated object covariance (non-smooth) on the 2D grid of dimension \code{length(tgrid)} X \code{length(tgrid)}}
\item{sC}{Estimated object covariance (smooth) on the 2D grid of dimension \code{length(tgrid)} X \code{length(tgrid)}}
\item{tgrid}{Time grid for the time varying object data and covariance function}
\item{K}{Numbers of principal components}
\item{phi}{Matrix of smooth eigenfunctions (dimension: \code{length(tgrid)} X \code{K})}
\item{lambda}{Vector of eigenvalues of dimension \code{K} }
}
\description{
Calculating covariance for time varying object data
}
\examples{
\donttest{
### functional covariate
phi1 <- function(x) -cos(pi*x/10)/sqrt(5)
phi2 <- function(x)  sin(pi*x/10)/sqrt(5)

lambdaX <- c(4,2)
# training set
n <- 100
N <- 50
tgrid <- seq(0,10,length.out = N)

Xi <- matrix(rnorm(2*n),nrow=n,ncol=2)
CovX <- lambdaX[1] * phi1(tgrid) \%*\% t(phi1(tgrid)) + lambdaX[2] * phi2(tgrid) \%*\% t(phi2(tgrid))
comp1 = lambdaX[1]^(1/2) * Xi[,1] \%*\% t(phi1(tgrid))
comp2 = lambdaX[2]^(1/2) * Xi[,2] \%*\% t(phi2(tgrid))
SampleX <- comp1 + comp2

I <- array(0, c(n,n,N,N))
for (u in 1:N){
  for (v in 1:N){
    temp1 <- SampleX[,u]
   temp2 <- SampleX[,v]
    I[,,u,v] <- outer(temp1, temp2, function(v1,v2){
     (v1 - v2)^2
   })
 }
}

result_cov <- ObjCov(tgrid, I, 2)
result_cov$lambda #4 2

sC <- result_cov$sC
sum((sC-CovX)^2) / sum(sC^2)
sum((phi1(tgrid)-result_cov$phi[,1])^2)/sum(phi1(tgrid)^2)
}
}
\references{
\cite{Dubey, P., & Müller, H. G. (2020). Functional models for time‐varying random objects. Journal of the Royal Statistical Society: Series B (Statistical Methodology), 82(2), 275-327.}
}
