% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vars-bs4dash.R
\name{bs4dash_layout}
\alias{bs4dash_layout}
\title{bs4Dash layout options}
\usage{
bs4dash_layout(
  font_size_root = NULL,
  sidebar_width = NULL,
  sidebar_padding_x = NULL,
  sidebar_padding_y = NULL,
  sidebar_mini_width = NULL,
  control_sidebar_width = NULL,
  boxed_layout_max_width = NULL,
  screen_header_collapse = NULL,
  main_bg = NULL,
  content_padding_x = NULL,
  content_padding_y = NULL
)
}
\arguments{
\item{font_size_root}{Font size root.}

\item{sidebar_width}{Sidebar width.}

\item{sidebar_padding_x}{Sidebar horizontal padding.}

\item{sidebar_padding_y}{Sidebar vertical padding.}

\item{sidebar_mini_width}{Width for mini sidebar.}

\item{control_sidebar_width}{Control sidebar width (the one on the right).}

\item{boxed_layout_max_width}{Max width used in boxed layout.}

\item{screen_header_collapse}{When to show the smaller logo.}

\item{main_bg}{Main background color.}

\item{content_padding_x}{Main content horizontal padding.}

\item{content_padding_y}{Main content vertical padding.}
}
\value{
a \code{list} that can be used in \code{\link{create_theme}}.
}
\description{
bs4Dash layout options
}
\examples{

# Sidebar width
bs4dash_layout(
  sidebar_width = "400px"
)

if (interactive()) {

  library(shiny)
  library(bs4Dash)

  ui <- bs4DashPage(
    title = "bs4Dash big sidebar",
    navbar = bs4DashNavbar(),
    sidebar = bs4DashSidebar(
      title = "bs4Dash big sidebar",
      skin = "light",
      bs4SidebarMenu(
        bs4SidebarMenuItem(
          tabName = "tab1",
          text = "UI components"
        )
      )
    ),
    body = bs4DashBody(

      use_theme(create_theme(
        bs4dash_layout(
          sidebar_width = "600px"
        )
      )),

      bs4TabItems(
        bs4TabItem(
          tabName = "tab1",
          "Content tab 1"
        )
      )
    )
  )

  server <- function(input, output) {

  }

  shinyApp(ui, server)

}

}
