# comments ---------------------------------------------------------------------

# Here's a potentially faster and more precise way to do this (that I might try)
# that uses the character representation of the number instead.
#
# Suppose our number is 1000000 (one million).
# 1. Use `sprintf()`, `format()`, or other to convert to character: "1000000"
# 2. Front pad with 0's so `nchar(x)` is a multiple of three: "001000000"
# 3. Process the number using a revised `english_naturals()`
# - `consume_hundreds()` uses `substr()` to remove the last 3 chars (still vectorized)
# - `get_hundreds()` uses `substr()` to get the last 3 chars (still vectorized)
# - `english$hundreds` is now a named dictionary "001" = "one", "101" = "one hundred and one"
# - The number of suffixes (-illions) required is `nchar(x) %/% 3`
#   - Conveniently, every suffix required can be made by `illions(seq(max(nchar(x) %/% 3)))`
#
# There might be some additional speed improvements because for each number we
# now know the required suffixes in advance (using `nchar()`). A `cumber_friendly()`
# (character-number) function for arbitrary precision would then be trivial.

# constants --------------------------------------------------------------------
english <- new.env(parent = emptyenv())

english$hundreds <- c(
  "", "one", "two", "three", "four", "five", "six", "seven",
  "eight", "nine", "ten", "eleven", "twelve", "thirteen", "fourteen",
  "fifteen", "sixteen", "seventeen", "eighteen", "nineteen", "twenty",
  "twenty-one", "twenty-two", "twenty-three", "twenty-four", "twenty-five",
  "twenty-six", "twenty-seven", "twenty-eight", "twenty-nine",
  "thirty", "thirty-one", "thirty-two", "thirty-three", "thirty-four",
  "thirty-five", "thirty-six", "thirty-seven", "thirty-eight",
  "thirty-nine", "forty", "forty-one", "forty-two", "forty-three",
  "forty-four", "forty-five", "forty-six", "forty-seven", "forty-eight",
  "forty-nine", "fifty", "fifty-one", "fifty-two", "fifty-three",
  "fifty-four", "fifty-five", "fifty-six", "fifty-seven", "fifty-eight",
  "fifty-nine", "sixty", "sixty-one", "sixty-two", "sixty-three",
  "sixty-four", "sixty-five", "sixty-six", "sixty-seven", "sixty-eight",
  "sixty-nine", "seventy", "seventy-one", "seventy-two", "seventy-three",
  "seventy-four", "seventy-five", "seventy-six", "seventy-seven",
  "seventy-eight", "seventy-nine", "eighty", "eighty-one", "eighty-two",
  "eighty-three", "eighty-four", "eighty-five", "eighty-six", "eighty-seven",
  "eighty-eight", "eighty-nine", "ninety", "ninety-one", "ninety-two",
  "ninety-three", "ninety-four", "ninety-five", "ninety-six", "ninety-seven",
  "ninety-eight", "ninety-nine", "one hundred", "one hundred one",
  "one hundred two", "one hundred three", "one hundred four", "one hundred five",
  "one hundred six", "one hundred seven", "one hundred eight",
  "one hundred nine", "one hundred ten", "one hundred eleven",
  "one hundred twelve", "one hundred thirteen", "one hundred fourteen",
  "one hundred fifteen", "one hundred sixteen", "one hundred seventeen",
  "one hundred eighteen", "one hundred nineteen", "one hundred twenty",
  "one hundred twenty-one", "one hundred twenty-two", "one hundred twenty-three",
  "one hundred twenty-four", "one hundred twenty-five", "one hundred twenty-six",
  "one hundred twenty-seven", "one hundred twenty-eight", "one hundred twenty-nine",
  "one hundred thirty", "one hundred thirty-one", "one hundred thirty-two",
  "one hundred thirty-three", "one hundred thirty-four", "one hundred thirty-five",
  "one hundred thirty-six", "one hundred thirty-seven", "one hundred thirty-eight",
  "one hundred thirty-nine", "one hundred forty", "one hundred forty-one",
  "one hundred forty-two", "one hundred forty-three", "one hundred forty-four",
  "one hundred forty-five", "one hundred forty-six", "one hundred forty-seven",
  "one hundred forty-eight", "one hundred forty-nine", "one hundred fifty",
  "one hundred fifty-one", "one hundred fifty-two", "one hundred fifty-three",
  "one hundred fifty-four", "one hundred fifty-five", "one hundred fifty-six",
  "one hundred fifty-seven", "one hundred fifty-eight", "one hundred fifty-nine",
  "one hundred sixty", "one hundred sixty-one", "one hundred sixty-two",
  "one hundred sixty-three", "one hundred sixty-four", "one hundred sixty-five",
  "one hundred sixty-six", "one hundred sixty-seven", "one hundred sixty-eight",
  "one hundred sixty-nine", "one hundred seventy", "one hundred seventy-one",
  "one hundred seventy-two", "one hundred seventy-three", "one hundred seventy-four",
  "one hundred seventy-five", "one hundred seventy-six", "one hundred seventy-seven",
  "one hundred seventy-eight", "one hundred seventy-nine", "one hundred eighty",
  "one hundred eighty-one", "one hundred eighty-two", "one hundred eighty-three",
  "one hundred eighty-four", "one hundred eighty-five", "one hundred eighty-six",
  "one hundred eighty-seven", "one hundred eighty-eight", "one hundred eighty-nine",
  "one hundred ninety", "one hundred ninety-one", "one hundred ninety-two",
  "one hundred ninety-three", "one hundred ninety-four", "one hundred ninety-five",
  "one hundred ninety-six", "one hundred ninety-seven", "one hundred ninety-eight",
  "one hundred ninety-nine", "two hundred", "two hundred one",
  "two hundred two", "two hundred three", "two hundred four", "two hundred five",
  "two hundred six", "two hundred seven", "two hundred eight",
  "two hundred nine", "two hundred ten", "two hundred eleven",
  "two hundred twelve", "two hundred thirteen", "two hundred fourteen",
  "two hundred fifteen", "two hundred sixteen", "two hundred seventeen",
  "two hundred eighteen", "two hundred nineteen", "two hundred twenty",
  "two hundred twenty-one", "two hundred twenty-two", "two hundred twenty-three",
  "two hundred twenty-four", "two hundred twenty-five", "two hundred twenty-six",
  "two hundred twenty-seven", "two hundred twenty-eight", "two hundred twenty-nine",
  "two hundred thirty", "two hundred thirty-one", "two hundred thirty-two",
  "two hundred thirty-three", "two hundred thirty-four", "two hundred thirty-five",
  "two hundred thirty-six", "two hundred thirty-seven", "two hundred thirty-eight",
  "two hundred thirty-nine", "two hundred forty", "two hundred forty-one",
  "two hundred forty-two", "two hundred forty-three", "two hundred forty-four",
  "two hundred forty-five", "two hundred forty-six", "two hundred forty-seven",
  "two hundred forty-eight", "two hundred forty-nine", "two hundred fifty",
  "two hundred fifty-one", "two hundred fifty-two", "two hundred fifty-three",
  "two hundred fifty-four", "two hundred fifty-five", "two hundred fifty-six",
  "two hundred fifty-seven", "two hundred fifty-eight", "two hundred fifty-nine",
  "two hundred sixty", "two hundred sixty-one", "two hundred sixty-two",
  "two hundred sixty-three", "two hundred sixty-four", "two hundred sixty-five",
  "two hundred sixty-six", "two hundred sixty-seven", "two hundred sixty-eight",
  "two hundred sixty-nine", "two hundred seventy", "two hundred seventy-one",
  "two hundred seventy-two", "two hundred seventy-three", "two hundred seventy-four",
  "two hundred seventy-five", "two hundred seventy-six", "two hundred seventy-seven",
  "two hundred seventy-eight", "two hundred seventy-nine", "two hundred eighty",
  "two hundred eighty-one", "two hundred eighty-two", "two hundred eighty-three",
  "two hundred eighty-four", "two hundred eighty-five", "two hundred eighty-six",
  "two hundred eighty-seven", "two hundred eighty-eight", "two hundred eighty-nine",
  "two hundred ninety", "two hundred ninety-one", "two hundred ninety-two",
  "two hundred ninety-three", "two hundred ninety-four", "two hundred ninety-five",
  "two hundred ninety-six", "two hundred ninety-seven", "two hundred ninety-eight",
  "two hundred ninety-nine", "three hundred", "three hundred one",
  "three hundred two", "three hundred three", "three hundred four",
  "three hundred five", "three hundred six", "three hundred seven",
  "three hundred eight", "three hundred nine", "three hundred ten",
  "three hundred eleven", "three hundred twelve", "three hundred thirteen",
  "three hundred fourteen", "three hundred fifteen", "three hundred sixteen",
  "three hundred seventeen", "three hundred eighteen", "three hundred nineteen",
  "three hundred twenty", "three hundred twenty-one", "three hundred twenty-two",
  "three hundred twenty-three", "three hundred twenty-four", "three hundred twenty-five",
  "three hundred twenty-six", "three hundred twenty-seven", "three hundred twenty-eight",
  "three hundred twenty-nine", "three hundred thirty", "three hundred thirty-one",
  "three hundred thirty-two", "three hundred thirty-three", "three hundred thirty-four",
  "three hundred thirty-five", "three hundred thirty-six", "three hundred thirty-seven",
  "three hundred thirty-eight", "three hundred thirty-nine", "three hundred forty",
  "three hundred forty-one", "three hundred forty-two", "three hundred forty-three",
  "three hundred forty-four", "three hundred forty-five", "three hundred forty-six",
  "three hundred forty-seven", "three hundred forty-eight", "three hundred forty-nine",
  "three hundred fifty", "three hundred fifty-one", "three hundred fifty-two",
  "three hundred fifty-three", "three hundred fifty-four", "three hundred fifty-five",
  "three hundred fifty-six", "three hundred fifty-seven", "three hundred fifty-eight",
  "three hundred fifty-nine", "three hundred sixty", "three hundred sixty-one",
  "three hundred sixty-two", "three hundred sixty-three", "three hundred sixty-four",
  "three hundred sixty-five", "three hundred sixty-six", "three hundred sixty-seven",
  "three hundred sixty-eight", "three hundred sixty-nine", "three hundred seventy",
  "three hundred seventy-one", "three hundred seventy-two", "three hundred seventy-three",
  "three hundred seventy-four", "three hundred seventy-five", "three hundred seventy-six",
  "three hundred seventy-seven", "three hundred seventy-eight",
  "three hundred seventy-nine", "three hundred eighty", "three hundred eighty-one",
  "three hundred eighty-two", "three hundred eighty-three", "three hundred eighty-four",
  "three hundred eighty-five", "three hundred eighty-six", "three hundred eighty-seven",
  "three hundred eighty-eight", "three hundred eighty-nine", "three hundred ninety",
  "three hundred ninety-one", "three hundred ninety-two", "three hundred ninety-three",
  "three hundred ninety-four", "three hundred ninety-five", "three hundred ninety-six",
  "three hundred ninety-seven", "three hundred ninety-eight", "three hundred ninety-nine",
  "four hundred", "four hundred one", "four hundred two", "four hundred three",
  "four hundred four", "four hundred five", "four hundred six",
  "four hundred seven", "four hundred eight", "four hundred nine",
  "four hundred ten", "four hundred eleven", "four hundred twelve",
  "four hundred thirteen", "four hundred fourteen", "four hundred fifteen",
  "four hundred sixteen", "four hundred seventeen", "four hundred eighteen",
  "four hundred nineteen", "four hundred twenty", "four hundred twenty-one",
  "four hundred twenty-two", "four hundred twenty-three", "four hundred twenty-four",
  "four hundred twenty-five", "four hundred twenty-six", "four hundred twenty-seven",
  "four hundred twenty-eight", "four hundred twenty-nine", "four hundred thirty",
  "four hundred thirty-one", "four hundred thirty-two", "four hundred thirty-three",
  "four hundred thirty-four", "four hundred thirty-five", "four hundred thirty-six",
  "four hundred thirty-seven", "four hundred thirty-eight", "four hundred thirty-nine",
  "four hundred forty", "four hundred forty-one", "four hundred forty-two",
  "four hundred forty-three", "four hundred forty-four", "four hundred forty-five",
  "four hundred forty-six", "four hundred forty-seven", "four hundred forty-eight",
  "four hundred forty-nine", "four hundred fifty", "four hundred fifty-one",
  "four hundred fifty-two", "four hundred fifty-three", "four hundred fifty-four",
  "four hundred fifty-five", "four hundred fifty-six", "four hundred fifty-seven",
  "four hundred fifty-eight", "four hundred fifty-nine", "four hundred sixty",
  "four hundred sixty-one", "four hundred sixty-two", "four hundred sixty-three",
  "four hundred sixty-four", "four hundred sixty-five", "four hundred sixty-six",
  "four hundred sixty-seven", "four hundred sixty-eight", "four hundred sixty-nine",
  "four hundred seventy", "four hundred seventy-one", "four hundred seventy-two",
  "four hundred seventy-three", "four hundred seventy-four", "four hundred seventy-five",
  "four hundred seventy-six", "four hundred seventy-seven", "four hundred seventy-eight",
  "four hundred seventy-nine", "four hundred eighty", "four hundred eighty-one",
  "four hundred eighty-two", "four hundred eighty-three", "four hundred eighty-four",
  "four hundred eighty-five", "four hundred eighty-six", "four hundred eighty-seven",
  "four hundred eighty-eight", "four hundred eighty-nine", "four hundred ninety",
  "four hundred ninety-one", "four hundred ninety-two", "four hundred ninety-three",
  "four hundred ninety-four", "four hundred ninety-five", "four hundred ninety-six",
  "four hundred ninety-seven", "four hundred ninety-eight", "four hundred ninety-nine",
  "five hundred", "five hundred one", "five hundred two", "five hundred three",
  "five hundred four", "five hundred five", "five hundred six",
  "five hundred seven", "five hundred eight", "five hundred nine",
  "five hundred ten", "five hundred eleven", "five hundred twelve",
  "five hundred thirteen", "five hundred fourteen", "five hundred fifteen",
  "five hundred sixteen", "five hundred seventeen", "five hundred eighteen",
  "five hundred nineteen", "five hundred twenty", "five hundred twenty-one",
  "five hundred twenty-two", "five hundred twenty-three", "five hundred twenty-four",
  "five hundred twenty-five", "five hundred twenty-six", "five hundred twenty-seven",
  "five hundred twenty-eight", "five hundred twenty-nine", "five hundred thirty",
  "five hundred thirty-one", "five hundred thirty-two", "five hundred thirty-three",
  "five hundred thirty-four", "five hundred thirty-five", "five hundred thirty-six",
  "five hundred thirty-seven", "five hundred thirty-eight", "five hundred thirty-nine",
  "five hundred forty", "five hundred forty-one", "five hundred forty-two",
  "five hundred forty-three", "five hundred forty-four", "five hundred forty-five",
  "five hundred forty-six", "five hundred forty-seven", "five hundred forty-eight",
  "five hundred forty-nine", "five hundred fifty", "five hundred fifty-one",
  "five hundred fifty-two", "five hundred fifty-three", "five hundred fifty-four",
  "five hundred fifty-five", "five hundred fifty-six", "five hundred fifty-seven",
  "five hundred fifty-eight", "five hundred fifty-nine", "five hundred sixty",
  "five hundred sixty-one", "five hundred sixty-two", "five hundred sixty-three",
  "five hundred sixty-four", "five hundred sixty-five", "five hundred sixty-six",
  "five hundred sixty-seven", "five hundred sixty-eight", "five hundred sixty-nine",
  "five hundred seventy", "five hundred seventy-one", "five hundred seventy-two",
  "five hundred seventy-three", "five hundred seventy-four", "five hundred seventy-five",
  "five hundred seventy-six", "five hundred seventy-seven", "five hundred seventy-eight",
  "five hundred seventy-nine", "five hundred eighty", "five hundred eighty-one",
  "five hundred eighty-two", "five hundred eighty-three", "five hundred eighty-four",
  "five hundred eighty-five", "five hundred eighty-six", "five hundred eighty-seven",
  "five hundred eighty-eight", "five hundred eighty-nine", "five hundred ninety",
  "five hundred ninety-one", "five hundred ninety-two", "five hundred ninety-three",
  "five hundred ninety-four", "five hundred ninety-five", "five hundred ninety-six",
  "five hundred ninety-seven", "five hundred ninety-eight", "five hundred ninety-nine",
  "six hundred", "six hundred one", "six hundred two", "six hundred three",
  "six hundred four", "six hundred five", "six hundred six", "six hundred seven",
  "six hundred eight", "six hundred nine", "six hundred ten", "six hundred eleven",
  "six hundred twelve", "six hundred thirteen", "six hundred fourteen",
  "six hundred fifteen", "six hundred sixteen", "six hundred seventeen",
  "six hundred eighteen", "six hundred nineteen", "six hundred twenty",
  "six hundred twenty-one", "six hundred twenty-two", "six hundred twenty-three",
  "six hundred twenty-four", "six hundred twenty-five", "six hundred twenty-six",
  "six hundred twenty-seven", "six hundred twenty-eight", "six hundred twenty-nine",
  "six hundred thirty", "six hundred thirty-one", "six hundred thirty-two",
  "six hundred thirty-three", "six hundred thirty-four", "six hundred thirty-five",
  "six hundred thirty-six", "six hundred thirty-seven", "six hundred thirty-eight",
  "six hundred thirty-nine", "six hundred forty", "six hundred forty-one",
  "six hundred forty-two", "six hundred forty-three", "six hundred forty-four",
  "six hundred forty-five", "six hundred forty-six", "six hundred forty-seven",
  "six hundred forty-eight", "six hundred forty-nine", "six hundred fifty",
  "six hundred fifty-one", "six hundred fifty-two", "six hundred fifty-three",
  "six hundred fifty-four", "six hundred fifty-five", "six hundred fifty-six",
  "six hundred fifty-seven", "six hundred fifty-eight", "six hundred fifty-nine",
  "six hundred sixty", "six hundred sixty-one", "six hundred sixty-two",
  "six hundred sixty-three", "six hundred sixty-four", "six hundred sixty-five",
  "six hundred sixty-six", "six hundred sixty-seven", "six hundred sixty-eight",
  "six hundred sixty-nine", "six hundred seventy", "six hundred seventy-one",
  "six hundred seventy-two", "six hundred seventy-three", "six hundred seventy-four",
  "six hundred seventy-five", "six hundred seventy-six", "six hundred seventy-seven",
  "six hundred seventy-eight", "six hundred seventy-nine", "six hundred eighty",
  "six hundred eighty-one", "six hundred eighty-two", "six hundred eighty-three",
  "six hundred eighty-four", "six hundred eighty-five", "six hundred eighty-six",
  "six hundred eighty-seven", "six hundred eighty-eight", "six hundred eighty-nine",
  "six hundred ninety", "six hundred ninety-one", "six hundred ninety-two",
  "six hundred ninety-three", "six hundred ninety-four", "six hundred ninety-five",
  "six hundred ninety-six", "six hundred ninety-seven", "six hundred ninety-eight",
  "six hundred ninety-nine", "seven hundred", "seven hundred one",
  "seven hundred two", "seven hundred three", "seven hundred four",
  "seven hundred five", "seven hundred six", "seven hundred seven",
  "seven hundred eight", "seven hundred nine", "seven hundred ten",
  "seven hundred eleven", "seven hundred twelve", "seven hundred thirteen",
  "seven hundred fourteen", "seven hundred fifteen", "seven hundred sixteen",
  "seven hundred seventeen", "seven hundred eighteen", "seven hundred nineteen",
  "seven hundred twenty", "seven hundred twenty-one", "seven hundred twenty-two",
  "seven hundred twenty-three", "seven hundred twenty-four", "seven hundred twenty-five",
  "seven hundred twenty-six", "seven hundred twenty-seven", "seven hundred twenty-eight",
  "seven hundred twenty-nine", "seven hundred thirty", "seven hundred thirty-one",
  "seven hundred thirty-two", "seven hundred thirty-three", "seven hundred thirty-four",
  "seven hundred thirty-five", "seven hundred thirty-six", "seven hundred thirty-seven",
  "seven hundred thirty-eight", "seven hundred thirty-nine", "seven hundred forty",
  "seven hundred forty-one", "seven hundred forty-two", "seven hundred forty-three",
  "seven hundred forty-four", "seven hundred forty-five", "seven hundred forty-six",
  "seven hundred forty-seven", "seven hundred forty-eight", "seven hundred forty-nine",
  "seven hundred fifty", "seven hundred fifty-one", "seven hundred fifty-two",
  "seven hundred fifty-three", "seven hundred fifty-four", "seven hundred fifty-five",
  "seven hundred fifty-six", "seven hundred fifty-seven", "seven hundred fifty-eight",
  "seven hundred fifty-nine", "seven hundred sixty", "seven hundred sixty-one",
  "seven hundred sixty-two", "seven hundred sixty-three", "seven hundred sixty-four",
  "seven hundred sixty-five", "seven hundred sixty-six", "seven hundred sixty-seven",
  "seven hundred sixty-eight", "seven hundred sixty-nine", "seven hundred seventy",
  "seven hundred seventy-one", "seven hundred seventy-two", "seven hundred seventy-three",
  "seven hundred seventy-four", "seven hundred seventy-five", "seven hundred seventy-six",
  "seven hundred seventy-seven", "seven hundred seventy-eight",
  "seven hundred seventy-nine", "seven hundred eighty", "seven hundred eighty-one",
  "seven hundred eighty-two", "seven hundred eighty-three", "seven hundred eighty-four",
  "seven hundred eighty-five", "seven hundred eighty-six", "seven hundred eighty-seven",
  "seven hundred eighty-eight", "seven hundred eighty-nine", "seven hundred ninety",
  "seven hundred ninety-one", "seven hundred ninety-two", "seven hundred ninety-three",
  "seven hundred ninety-four", "seven hundred ninety-five", "seven hundred ninety-six",
  "seven hundred ninety-seven", "seven hundred ninety-eight", "seven hundred ninety-nine",
  "eight hundred", "eight hundred one", "eight hundred two", "eight hundred three",
  "eight hundred four", "eight hundred five", "eight hundred six",
  "eight hundred seven", "eight hundred eight", "eight hundred nine",
  "eight hundred ten", "eight hundred eleven", "eight hundred twelve",
  "eight hundred thirteen", "eight hundred fourteen", "eight hundred fifteen",
  "eight hundred sixteen", "eight hundred seventeen", "eight hundred eighteen",
  "eight hundred nineteen", "eight hundred twenty", "eight hundred twenty-one",
  "eight hundred twenty-two", "eight hundred twenty-three", "eight hundred twenty-four",
  "eight hundred twenty-five", "eight hundred twenty-six", "eight hundred twenty-seven",
  "eight hundred twenty-eight", "eight hundred twenty-nine", "eight hundred thirty",
  "eight hundred thirty-one", "eight hundred thirty-two", "eight hundred thirty-three",
  "eight hundred thirty-four", "eight hundred thirty-five", "eight hundred thirty-six",
  "eight hundred thirty-seven", "eight hundred thirty-eight", "eight hundred thirty-nine",
  "eight hundred forty", "eight hundred forty-one", "eight hundred forty-two",
  "eight hundred forty-three", "eight hundred forty-four", "eight hundred forty-five",
  "eight hundred forty-six", "eight hundred forty-seven", "eight hundred forty-eight",
  "eight hundred forty-nine", "eight hundred fifty", "eight hundred fifty-one",
  "eight hundred fifty-two", "eight hundred fifty-three", "eight hundred fifty-four",
  "eight hundred fifty-five", "eight hundred fifty-six", "eight hundred fifty-seven",
  "eight hundred fifty-eight", "eight hundred fifty-nine", "eight hundred sixty",
  "eight hundred sixty-one", "eight hundred sixty-two", "eight hundred sixty-three",
  "eight hundred sixty-four", "eight hundred sixty-five", "eight hundred sixty-six",
  "eight hundred sixty-seven", "eight hundred sixty-eight", "eight hundred sixty-nine",
  "eight hundred seventy", "eight hundred seventy-one", "eight hundred seventy-two",
  "eight hundred seventy-three", "eight hundred seventy-four",
  "eight hundred seventy-five", "eight hundred seventy-six", "eight hundred seventy-seven",
  "eight hundred seventy-eight", "eight hundred seventy-nine",
  "eight hundred eighty", "eight hundred eighty-one", "eight hundred eighty-two",
  "eight hundred eighty-three", "eight hundred eighty-four", "eight hundred eighty-five",
  "eight hundred eighty-six", "eight hundred eighty-seven", "eight hundred eighty-eight",
  "eight hundred eighty-nine", "eight hundred ninety", "eight hundred ninety-one",
  "eight hundred ninety-two", "eight hundred ninety-three", "eight hundred ninety-four",
  "eight hundred ninety-five", "eight hundred ninety-six", "eight hundred ninety-seven",
  "eight hundred ninety-eight", "eight hundred ninety-nine", "nine hundred",
  "nine hundred one", "nine hundred two", "nine hundred three",
  "nine hundred four", "nine hundred five", "nine hundred six",
  "nine hundred seven", "nine hundred eight", "nine hundred nine",
  "nine hundred ten", "nine hundred eleven", "nine hundred twelve",
  "nine hundred thirteen", "nine hundred fourteen", "nine hundred fifteen",
  "nine hundred sixteen", "nine hundred seventeen", "nine hundred eighteen",
  "nine hundred nineteen", "nine hundred twenty", "nine hundred twenty-one",
  "nine hundred twenty-two", "nine hundred twenty-three", "nine hundred twenty-four",
  "nine hundred twenty-five", "nine hundred twenty-six", "nine hundred twenty-seven",
  "nine hundred twenty-eight", "nine hundred twenty-nine", "nine hundred thirty",
  "nine hundred thirty-one", "nine hundred thirty-two", "nine hundred thirty-three",
  "nine hundred thirty-four", "nine hundred thirty-five", "nine hundred thirty-six",
  "nine hundred thirty-seven", "nine hundred thirty-eight", "nine hundred thirty-nine",
  "nine hundred forty", "nine hundred forty-one", "nine hundred forty-two",
  "nine hundred forty-three", "nine hundred forty-four", "nine hundred forty-five",
  "nine hundred forty-six", "nine hundred forty-seven", "nine hundred forty-eight",
  "nine hundred forty-nine", "nine hundred fifty", "nine hundred fifty-one",
  "nine hundred fifty-two", "nine hundred fifty-three", "nine hundred fifty-four",
  "nine hundred fifty-five", "nine hundred fifty-six", "nine hundred fifty-seven",
  "nine hundred fifty-eight", "nine hundred fifty-nine", "nine hundred sixty",
  "nine hundred sixty-one", "nine hundred sixty-two", "nine hundred sixty-three",
  "nine hundred sixty-four", "nine hundred sixty-five", "nine hundred sixty-six",
  "nine hundred sixty-seven", "nine hundred sixty-eight", "nine hundred sixty-nine",
  "nine hundred seventy", "nine hundred seventy-one", "nine hundred seventy-two",
  "nine hundred seventy-three", "nine hundred seventy-four", "nine hundred seventy-five",
  "nine hundred seventy-six", "nine hundred seventy-seven", "nine hundred seventy-eight",
  "nine hundred seventy-nine", "nine hundred eighty", "nine hundred eighty-one",
  "nine hundred eighty-two", "nine hundred eighty-three", "nine hundred eighty-four",
  "nine hundred eighty-five", "nine hundred eighty-six", "nine hundred eighty-seven",
  "nine hundred eighty-eight", "nine hundred eighty-nine", "nine hundred ninety",
  "nine hundred ninety-one", "nine hundred ninety-two", "nine hundred ninety-three",
  "nine hundred ninety-four", "nine hundred ninety-five", "nine hundred ninety-six",
  "nine hundred ninety-seven", "nine hundred ninety-eight", "nine hundred ninety-nine"
)

# Generated via `nice_illions(1:200)`. Maxes out at 1000^200. On my machine
# `.Machine$double.xmax = 1.797693e+308` is on the same order as 1000^{102.7},
# so we're fine for most realistic cases.
english$suffixes <- c(
  "", " thousand", " million", " billion", " trillion", " quadrillion",
  " quintillion", " sextillion", " septillion", " octillion", " nonillion",
  " decillion", " undecillion", " duodecillion", " tredecillion",
  " quattuordecillion", " quindecillion", " sedecillion", " septendecillion",
  " octodecillion", " novendecillion", " vigintillion", " unvigintillion",
  " duovigintillion", " tresvigintillion", " quattuorvigintillion",
  " quinvigintillion", " sesvigintillion", " septemvigintillion",
  " octovigintillion", " novemvigintillion", " trigintillion",
  " untrigintillion", " duotrigintillion", " trestrigintillion",
  " quattuortrigintillion", " quintrigintillion", " sestrigintillion",
  " septentrigintillion", " octotrigintillion", " noventrigintillion",
  " quadragintillion", " unquadragintillion", " duoquadragintillion",
  " tresquadragintillion", " quattuorquadragintillion", " quinquadragintillion",
  " sesquadragintillion", " septenquadragintillion", " octoquadragintillion",
  " novenquadragintillion", " quinquagintillion", " unquinquagintillion",
  " duoquinquagintillion", " tresquinquagintillion", " quattuorquinquagintillion",
  " quinquinquagintillion", " sesquinquagintillion", " septenquinquagintillion",
  " octoquinquagintillion", " novenquinquagintillion", " sexagintillion",
  " unsexagintillion", " duosexagintillion", " tresexagintillion",
  " quattuorsexagintillion", " quinsexagintillion", " sesexagintillion",
  " septensexagintillion", " octosexagintillion", " novensexagintillion",
  " septuagintillion", " unseptuagintillion", " duoseptuagintillion",
  " treseptuagintillion", " quattuorseptuagintillion", " quinseptuagintillion",
  " seseptuagintillion", " septenseptuagintillion", " octoseptuagintillion",
  " novenseptuagintillion", " octogintillion", " unoctogintillion",
  " duooctogintillion", " tresoctogintillion", " quattuoroctogintillion",
  " quinoctogintillion", " sexoctogintillion", " septemoctogintillion",
  " octooctogintillion", " novemoctogintillion", " nonagintillion",
  " unnonagintillion", " duononagintillion", " trenonagintillion",
  " quattuornonagintillion", " quinnonagintillion", " senonagintillion",
  " septenonagintillion", " octononagintillion", " novenonagintillion",
  " centillion", " uncentillion", " duocentillion", " trescentillion",
  " quattuorcentillion", " quincentillion", " sexcentillion", " septencentillion",
  " octocentillion", " novencentillion", " decicentillion", " undecicentillion",
  " duodecicentillion", " tredecicentillion", " quattuordecicentillion",
  " quindecicentillion", " sedecicentillion", " septendecicentillion",
  " octodecicentillion", " novendecicentillion", " viginticentillion",
  " unviginticentillion", " duoviginticentillion", " tresviginticentillion",
  " quattuorviginticentillion", " quinviginticentillion", " sesviginticentillion",
  " septemviginticentillion", " octoviginticentillion", " novemviginticentillion",
  " trigintacentillion", " untrigintacentillion", " duotrigintacentillion",
  " trestrigintacentillion", " quattuortrigintacentillion", " quintrigintacentillion",
  " sestrigintacentillion", " septentrigintacentillion", " octotrigintacentillion",
  " noventrigintacentillion", " quadragintacentillion", " unquadragintacentillion",
  " duoquadragintacentillion", " tresquadragintacentillion", " quattuorquadragintacentillion",
  " quinquadragintacentillion", " sesquadragintacentillion", " septenquadragintacentillion",
  " octoquadragintacentillion", " novenquadragintacentillion",
  " quinquagintacentillion", " unquinquagintacentillion", " duoquinquagintacentillion",
  " tresquinquagintacentillion", " quattuorquinquagintacentillion",
  " quinquinquagintacentillion", " sesquinquagintacentillion",
  " septenquinquagintacentillion", " octoquinquagintacentillion",
  " novenquinquagintacentillion", " sexagintacentillion", " unsexagintacentillion",
  " duosexagintacentillion", " tresexagintacentillion", " quattuorsexagintacentillion",
  " quinsexagintacentillion", " sesexagintacentillion", " septensexagintacentillion",
  " octosexagintacentillion", " novensexagintacentillion", " septuagintacentillion",
  " unseptuagintacentillion", " duoseptuagintacentillion", " treseptuagintacentillion",
  " quattuorseptuagintacentillion", " quinseptuagintacentillion",
  " seseptuagintacentillion", " septenseptuagintacentillion", " octoseptuagintacentillion",
  " novenseptuagintacentillion", " octogintacentillion", " unoctogintacentillion",
  " duooctogintacentillion", " tresoctogintacentillion", " quattuoroctogintacentillion",
  " quinoctogintacentillion", " sexoctogintacentillion", " septemoctogintacentillion",
  " octooctogintacentillion", " novemoctogintacentillion", " nonagintacentillion",
  " unnonagintacentillion", " duononagintacentillion", " trenonagintacentillion",
  " quattuornonagintacentillion", " quinnonagintacentillion", " senonagintacentillion",
  " septenonagintacentillion", " octononagintacentillion", " novenonagintacentillion"
)

english$illions <- c(
  "thousand", "million", "billion", "trillion", "quadrillion",
  "quintillion", "sextillion", "septillion", "octillion", "nonillion",
  "decillion", "undecillion", "duodecillion", "tredecillion", "quattuordecillion",
  "quindecillion", "sedecillion", "septendecillion", "octodecillion",
  "novendecillion", "vigintillion", "unvigintillion", "duovigintillion",
  "tresvigintillion", "quattuorvigintillion", "quinvigintillion",
  "sesvigintillion", "septemvigintillion", "octovigintillion",
  "novemvigintillion", "trigintillion", "untrigintillion", "duotrigintillion",
  "trestrigintillion", "quattuortrigintillion", "quintrigintillion",
  "sestrigintillion", "septentrigintillion", "octotrigintillion",
  "noventrigintillion", "quadragintillion", "unquadragintillion",
  "duoquadragintillion", "tresquadragintillion", "quattuorquadragintillion",
  "quinquadragintillion", "sesquadragintillion", "septenquadragintillion",
  "octoquadragintillion", "novenquadragintillion", "quinquagintillion",
  "unquinquagintillion", "duoquinquagintillion", "tresquinquagintillion",
  "quattuorquinquagintillion", "quinquinquagintillion", "sesquinquagintillion",
  "septenquinquagintillion", "octoquinquagintillion", "novenquinquagintillion",
  "sexagintillion", "unsexagintillion", "duosexagintillion", "tresexagintillion",
  "quattuorsexagintillion", "quinsexagintillion", "sesexagintillion",
  "septensexagintillion", "octosexagintillion", "novensexagintillion",
  "septuagintillion", "unseptuagintillion", "duoseptuagintillion",
  "treseptuagintillion", "quattuorseptuagintillion", "quinseptuagintillion",
  "seseptuagintillion", "septenseptuagintillion", "octoseptuagintillion",
  "novenseptuagintillion", "octogintillion", "unoctogintillion",
  "duooctogintillion", "tresoctogintillion", "quattuoroctogintillion",
  "quinoctogintillion", "sexoctogintillion", "septemoctogintillion",
  "octooctogintillion", "novemoctogintillion", "nonagintillion",
  "unnonagintillion", "duononagintillion", "trenonagintillion",
  "quattuornonagintillion", "quinnonagintillion", "senonagintillion",
  "septenonagintillion", "octononagintillion", "novenonagintillion",
  "centillion", "uncentillion", "duocentillion", "trescentillion",
  "quattuorcentillion", "quincentillion", "sexcentillion", "septencentillion",
  "octocentillion", "novencentillion", "decicentillion", "undecicentillion",
  "duodecicentillion", "tredecicentillion", "quattuordecicentillion",
  "quindecicentillion", "sedecicentillion", "septendecicentillion",
  "octodecicentillion", "novendecicentillion", "viginticentillion",
  "unviginticentillion", "duoviginticentillion", "tresviginticentillion",
  "quattuorviginticentillion", "quinviginticentillion", "sesviginticentillion",
  "septemviginticentillion", "octoviginticentillion", "novemviginticentillion",
  "trigintacentillion", "untrigintacentillion", "duotrigintacentillion",
  "trestrigintacentillion", "quattuortrigintacentillion", "quintrigintacentillion",
  "sestrigintacentillion", "septentrigintacentillion", "octotrigintacentillion",
  "noventrigintacentillion", "quadragintacentillion", "unquadragintacentillion",
  "duoquadragintacentillion", "tresquadragintacentillion", "quattuorquadragintacentillion",
  "quinquadragintacentillion", "sesquadragintacentillion", "septenquadragintacentillion",
  "octoquadragintacentillion", "novenquadragintacentillion", "quinquagintacentillion",
  "unquinquagintacentillion", "duoquinquagintacentillion", "tresquinquagintacentillion",
  "quattuorquinquagintacentillion", "quinquinquagintacentillion",
  "sesquinquagintacentillion", "septenquinquagintacentillion",
  "octoquinquagintacentillion", "novenquinquagintacentillion",
  "sexagintacentillion", "unsexagintacentillion", "duosexagintacentillion",
  "tresexagintacentillion", "quattuorsexagintacentillion", "quinsexagintacentillion",
  "sesexagintacentillion", "septensexagintacentillion", "octosexagintacentillion",
  "novensexagintacentillion", "septuagintacentillion", "unseptuagintacentillion",
  "duoseptuagintacentillion", "treseptuagintacentillion", "quattuorseptuagintacentillion",
  "quinseptuagintacentillion", "seseptuagintacentillion", "septenseptuagintacentillion",
  "octoseptuagintacentillion", "novenseptuagintacentillion", "octogintacentillion",
  "unoctogintacentillion", "duooctogintacentillion", "tresoctogintacentillion",
  "quattuoroctogintacentillion", "quinoctogintacentillion", "sexoctogintacentillion",
  "septemoctogintacentillion", "octooctogintacentillion", "novemoctogintacentillion",
  "nonagintacentillion", "unnonagintacentillion", "duononagintacentillion",
  "trenonagintacentillion", "quattuornonagintacentillion", "quinnonagintacentillion",
  "senonagintacentillion", "septenonagintacentillion", "octononagintacentillion",
  "novenonagintacentillion", "ducentillion", "unducentillion",
  "duoducentillion", "treducentillion", "quattuorducentillion",
  "quinducentillion", "seducentillion", "septenducentillion", "octoducentillion",
  "novenducentillion", "deciducentillion", "undeciducentillion",
  "duodeciducentillion", "tredeciducentillion", "quattuordeciducentillion",
  "quindeciducentillion", "sedeciducentillion", "septendeciducentillion",
  "octodeciducentillion", "novendeciducentillion", "vigintiducentillion",
  "unvigintiducentillion", "duovigintiducentillion", "tresvigintiducentillion",
  "quattuorvigintiducentillion", "quinvigintiducentillion", "sesvigintiducentillion",
  "septemvigintiducentillion", "octovigintiducentillion", "novemvigintiducentillion",
  "trigintaducentillion", "untrigintaducentillion", "duotrigintaducentillion",
  "trestrigintaducentillion", "quattuortrigintaducentillion", "quintrigintaducentillion",
  "sestrigintaducentillion", "septentrigintaducentillion", "octotrigintaducentillion",
  "noventrigintaducentillion", "quadragintaducentillion", "unquadragintaducentillion",
  "duoquadragintaducentillion", "tresquadragintaducentillion",
  "quattuorquadragintaducentillion", "quinquadragintaducentillion",
  "sesquadragintaducentillion", "septenquadragintaducentillion",
  "octoquadragintaducentillion", "novenquadragintaducentillion",
  "quinquagintaducentillion", "unquinquagintaducentillion", "duoquinquagintaducentillion",
  "tresquinquagintaducentillion", "quattuorquinquagintaducentillion",
  "quinquinquagintaducentillion", "sesquinquagintaducentillion",
  "septenquinquagintaducentillion", "octoquinquagintaducentillion",
  "novenquinquagintaducentillion", "sexagintaducentillion", "unsexagintaducentillion",
  "duosexagintaducentillion", "tresexagintaducentillion", "quattuorsexagintaducentillion",
  "quinsexagintaducentillion", "sesexagintaducentillion", "septensexagintaducentillion",
  "octosexagintaducentillion", "novensexagintaducentillion", "septuagintaducentillion",
  "unseptuagintaducentillion", "duoseptuagintaducentillion", "treseptuagintaducentillion",
  "quattuorseptuagintaducentillion", "quinseptuagintaducentillion",
  "seseptuagintaducentillion", "septenseptuagintaducentillion",
  "octoseptuagintaducentillion", "novenseptuagintaducentillion",
  "octogintaducentillion", "unoctogintaducentillion", "duooctogintaducentillion",
  "tresoctogintaducentillion", "quattuoroctogintaducentillion",
  "quinoctogintaducentillion", "sexoctogintaducentillion", "septemoctogintaducentillion",
  "octooctogintaducentillion", "novemoctogintaducentillion", "nonagintaducentillion",
  "unnonagintaducentillion", "duononagintaducentillion", "trenonagintaducentillion",
  "quattuornonagintaducentillion", "quinnonagintaducentillion",
  "senonagintaducentillion", "septenonagintaducentillion", "octononagintaducentillion",
  "novenonagintaducentillion", "trecentillion", "untrecentillion",
  "duotrecentillion", "trestrecentillion", "quattuortrecentillion",
  "quintrecentillion", "sestrecentillion", "septentrecentillion",
  "octotrecentillion", "noventrecentillion", "decitrecentillion",
  "undecitrecentillion", "duodecitrecentillion", "tredecitrecentillion",
  "quattuordecitrecentillion", "quindecitrecentillion", "sedecitrecentillion",
  "septendecitrecentillion", "octodecitrecentillion", "novendecitrecentillion",
  "vigintitrecentillion", "unvigintitrecentillion", "duovigintitrecentillion",
  "tresvigintitrecentillion", "quattuorvigintitrecentillion", "quinvigintitrecentillion",
  "sesvigintitrecentillion", "septemvigintitrecentillion", "octovigintitrecentillion",
  "novemvigintitrecentillion", "trigintatrecentillion", "untrigintatrecentillion",
  "duotrigintatrecentillion", "trestrigintatrecentillion", "quattuortrigintatrecentillion",
  "quintrigintatrecentillion", "sestrigintatrecentillion", "septentrigintatrecentillion",
  "octotrigintatrecentillion", "noventrigintatrecentillion", "quadragintatrecentillion",
  "unquadragintatrecentillion", "duoquadragintatrecentillion",
  "tresquadragintatrecentillion", "quattuorquadragintatrecentillion",
  "quinquadragintatrecentillion", "sesquadragintatrecentillion",
  "septenquadragintatrecentillion", "octoquadragintatrecentillion",
  "novenquadragintatrecentillion", "quinquagintatrecentillion",
  "unquinquagintatrecentillion", "duoquinquagintatrecentillion",
  "tresquinquagintatrecentillion", "quattuorquinquagintatrecentillion",
  "quinquinquagintatrecentillion", "sesquinquagintatrecentillion",
  "septenquinquagintatrecentillion", "octoquinquagintatrecentillion",
  "novenquinquagintatrecentillion", "sexagintatrecentillion", "unsexagintatrecentillion",
  "duosexagintatrecentillion", "tresexagintatrecentillion", "quattuorsexagintatrecentillion",
  "quinsexagintatrecentillion", "sesexagintatrecentillion", "septensexagintatrecentillion",
  "octosexagintatrecentillion", "novensexagintatrecentillion",
  "septuagintatrecentillion", "unseptuagintatrecentillion", "duoseptuagintatrecentillion",
  "treseptuagintatrecentillion", "quattuorseptuagintatrecentillion",
  "quinseptuagintatrecentillion", "seseptuagintatrecentillion",
  "septenseptuagintatrecentillion", "octoseptuagintatrecentillion",
  "novenseptuagintatrecentillion", "octogintatrecentillion", "unoctogintatrecentillion",
  "duooctogintatrecentillion", "tresoctogintatrecentillion", "quattuoroctogintatrecentillion",
  "quinoctogintatrecentillion", "sexoctogintatrecentillion", "septemoctogintatrecentillion",
  "octooctogintatrecentillion", "novemoctogintatrecentillion",
  "nonagintatrecentillion", "unnonagintatrecentillion", "duononagintatrecentillion",
  "trenonagintatrecentillion", "quattuornonagintatrecentillion",
  "quinnonagintatrecentillion", "senonagintatrecentillion", "septenonagintatrecentillion",
  "octononagintatrecentillion", "novenonagintatrecentillion", "quadringentillion",
  "unquadringentillion", "duoquadringentillion", "tresquadringentillion",
  "quattuorquadringentillion", "quinquadringentillion", "sesquadringentillion",
  "septenquadringentillion", "octoquadringentillion", "novenquadringentillion",
  "deciquadringentillion", "undeciquadringentillion", "duodeciquadringentillion",
  "tredeciquadringentillion", "quattuordeciquadringentillion",
  "quindeciquadringentillion", "sedeciquadringentillion", "septendeciquadringentillion",
  "octodeciquadringentillion", "novendeciquadringentillion", "vigintiquadringentillion",
  "unvigintiquadringentillion", "duovigintiquadringentillion",
  "tresvigintiquadringentillion", "quattuorvigintiquadringentillion",
  "quinvigintiquadringentillion", "sesvigintiquadringentillion",
  "septemvigintiquadringentillion", "octovigintiquadringentillion",
  "novemvigintiquadringentillion", "trigintaquadringentillion",
  "untrigintaquadringentillion", "duotrigintaquadringentillion",
  "trestrigintaquadringentillion", "quattuortrigintaquadringentillion",
  "quintrigintaquadringentillion", "sestrigintaquadringentillion",
  "septentrigintaquadringentillion", "octotrigintaquadringentillion",
  "noventrigintaquadringentillion", "quadragintaquadringentillion",
  "unquadragintaquadringentillion", "duoquadragintaquadringentillion",
  "tresquadragintaquadringentillion", "quattuorquadragintaquadringentillion",
  "quinquadragintaquadringentillion", "sesquadragintaquadringentillion",
  "septenquadragintaquadringentillion", "octoquadragintaquadringentillion",
  "novenquadragintaquadringentillion", "quinquagintaquadringentillion",
  "unquinquagintaquadringentillion", "duoquinquagintaquadringentillion",
  "tresquinquagintaquadringentillion", "quattuorquinquagintaquadringentillion",
  "quinquinquagintaquadringentillion", "sesquinquagintaquadringentillion",
  "septenquinquagintaquadringentillion", "octoquinquagintaquadringentillion",
  "novenquinquagintaquadringentillion", "sexagintaquadringentillion",
  "unsexagintaquadringentillion", "duosexagintaquadringentillion",
  "tresexagintaquadringentillion", "quattuorsexagintaquadringentillion",
  "quinsexagintaquadringentillion", "sesexagintaquadringentillion",
  "septensexagintaquadringentillion", "octosexagintaquadringentillion",
  "novensexagintaquadringentillion", "septuagintaquadringentillion",
  "unseptuagintaquadringentillion", "duoseptuagintaquadringentillion",
  "treseptuagintaquadringentillion", "quattuorseptuagintaquadringentillion",
  "quinseptuagintaquadringentillion", "seseptuagintaquadringentillion",
  "septenseptuagintaquadringentillion", "octoseptuagintaquadringentillion",
  "novenseptuagintaquadringentillion", "octogintaquadringentillion",
  "unoctogintaquadringentillion", "duooctogintaquadringentillion",
  "tresoctogintaquadringentillion", "quattuoroctogintaquadringentillion",
  "quinoctogintaquadringentillion", "sexoctogintaquadringentillion",
  "septemoctogintaquadringentillion", "octooctogintaquadringentillion",
  "novemoctogintaquadringentillion", "nonagintaquadringentillion",
  "unnonagintaquadringentillion", "duononagintaquadringentillion",
  "trenonagintaquadringentillion", "quattuornonagintaquadringentillion",
  "quinnonagintaquadringentillion", "senonagintaquadringentillion",
  "septenonagintaquadringentillion", "octononagintaquadringentillion",
  "novenonagintaquadringentillion", "quingentillion", "unquingentillion",
  "duoquingentillion", "tresquingentillion", "quattuorquingentillion",
  "quinquingentillion", "sesquingentillion", "septenquingentillion",
  "octoquingentillion", "novenquingentillion", "deciquingentillion",
  "undeciquingentillion", "duodeciquingentillion", "tredeciquingentillion",
  "quattuordeciquingentillion", "quindeciquingentillion", "sedeciquingentillion",
  "septendeciquingentillion", "octodeciquingentillion", "novendeciquingentillion",
  "vigintiquingentillion", "unvigintiquingentillion", "duovigintiquingentillion",
  "tresvigintiquingentillion", "quattuorvigintiquingentillion",
  "quinvigintiquingentillion", "sesvigintiquingentillion", "septemvigintiquingentillion",
  "octovigintiquingentillion", "novemvigintiquingentillion", "trigintaquingentillion",
  "untrigintaquingentillion", "duotrigintaquingentillion", "trestrigintaquingentillion",
  "quattuortrigintaquingentillion", "quintrigintaquingentillion",
  "sestrigintaquingentillion", "septentrigintaquingentillion",
  "octotrigintaquingentillion", "noventrigintaquingentillion",
  "quadragintaquingentillion", "unquadragintaquingentillion", "duoquadragintaquingentillion",
  "tresquadragintaquingentillion", "quattuorquadragintaquingentillion",
  "quinquadragintaquingentillion", "sesquadragintaquingentillion",
  "septenquadragintaquingentillion", "octoquadragintaquingentillion",
  "novenquadragintaquingentillion", "quinquagintaquingentillion",
  "unquinquagintaquingentillion", "duoquinquagintaquingentillion",
  "tresquinquagintaquingentillion", "quattuorquinquagintaquingentillion",
  "quinquinquagintaquingentillion", "sesquinquagintaquingentillion",
  "septenquinquagintaquingentillion", "octoquinquagintaquingentillion",
  "novenquinquagintaquingentillion", "sexagintaquingentillion",
  "unsexagintaquingentillion", "duosexagintaquingentillion", "tresexagintaquingentillion",
  "quattuorsexagintaquingentillion", "quinsexagintaquingentillion",
  "sesexagintaquingentillion", "septensexagintaquingentillion",
  "octosexagintaquingentillion", "novensexagintaquingentillion",
  "septuagintaquingentillion", "unseptuagintaquingentillion", "duoseptuagintaquingentillion",
  "treseptuagintaquingentillion", "quattuorseptuagintaquingentillion",
  "quinseptuagintaquingentillion", "seseptuagintaquingentillion",
  "septenseptuagintaquingentillion", "octoseptuagintaquingentillion",
  "novenseptuagintaquingentillion", "octogintaquingentillion",
  "unoctogintaquingentillion", "duooctogintaquingentillion", "tresoctogintaquingentillion",
  "quattuoroctogintaquingentillion", "quinoctogintaquingentillion",
  "sexoctogintaquingentillion", "septemoctogintaquingentillion",
  "octooctogintaquingentillion", "novemoctogintaquingentillion",
  "nonagintaquingentillion", "unnonagintaquingentillion", "duononagintaquingentillion",
  "trenonagintaquingentillion", "quattuornonagintaquingentillion",
  "quinnonagintaquingentillion", "senonagintaquingentillion", "septenonagintaquingentillion",
  "octononagintaquingentillion", "novenonagintaquingentillion",
  "sescentillion", "unsescentillion", "duosescentillion", "tresescentillion",
  "quattuorsescentillion", "quinsescentillion", "sesescentillion",
  "septensescentillion", "octosescentillion", "novensescentillion",
  "decisescentillion", "undecisescentillion", "duodecisescentillion",
  "tredecisescentillion", "quattuordecisescentillion", "quindecisescentillion",
  "sedecisescentillion", "septendecisescentillion", "octodecisescentillion",
  "novendecisescentillion", "vigintisescentillion", "unvigintisescentillion",
  "duovigintisescentillion", "tresvigintisescentillion", "quattuorvigintisescentillion",
  "quinvigintisescentillion", "sesvigintisescentillion", "septemvigintisescentillion",
  "octovigintisescentillion", "novemvigintisescentillion", "trigintasescentillion",
  "untrigintasescentillion", "duotrigintasescentillion", "trestrigintasescentillion",
  "quattuortrigintasescentillion", "quintrigintasescentillion",
  "sestrigintasescentillion", "septentrigintasescentillion", "octotrigintasescentillion",
  "noventrigintasescentillion", "quadragintasescentillion", "unquadragintasescentillion",
  "duoquadragintasescentillion", "tresquadragintasescentillion",
  "quattuorquadragintasescentillion", "quinquadragintasescentillion",
  "sesquadragintasescentillion", "septenquadragintasescentillion",
  "octoquadragintasescentillion", "novenquadragintasescentillion",
  "quinquagintasescentillion", "unquinquagintasescentillion", "duoquinquagintasescentillion",
  "tresquinquagintasescentillion", "quattuorquinquagintasescentillion",
  "quinquinquagintasescentillion", "sesquinquagintasescentillion",
  "septenquinquagintasescentillion", "octoquinquagintasescentillion",
  "novenquinquagintasescentillion", "sexagintasescentillion", "unsexagintasescentillion",
  "duosexagintasescentillion", "tresexagintasescentillion", "quattuorsexagintasescentillion",
  "quinsexagintasescentillion", "sesexagintasescentillion", "septensexagintasescentillion",
  "octosexagintasescentillion", "novensexagintasescentillion",
  "septuagintasescentillion", "unseptuagintasescentillion", "duoseptuagintasescentillion",
  "treseptuagintasescentillion", "quattuorseptuagintasescentillion",
  "quinseptuagintasescentillion", "seseptuagintasescentillion",
  "septenseptuagintasescentillion", "octoseptuagintasescentillion",
  "novenseptuagintasescentillion", "octogintasescentillion", "unoctogintasescentillion",
  "duooctogintasescentillion", "tresoctogintasescentillion", "quattuoroctogintasescentillion",
  "quinoctogintasescentillion", "sexoctogintasescentillion", "septemoctogintasescentillion",
  "octooctogintasescentillion", "novemoctogintasescentillion",
  "nonagintasescentillion", "unnonagintasescentillion", "duononagintasescentillion",
  "trenonagintasescentillion", "quattuornonagintasescentillion",
  "quinnonagintasescentillion", "senonagintasescentillion", "septenonagintasescentillion",
  "octononagintasescentillion", "novenonagintasescentillion", "septingentillion",
  "unseptingentillion", "duoseptingentillion", "treseptingentillion",
  "quattuorseptingentillion", "quinseptingentillion", "seseptingentillion",
  "septenseptingentillion", "octoseptingentillion", "novenseptingentillion",
  "deciseptingentillion", "undeciseptingentillion", "duodeciseptingentillion",
  "tredeciseptingentillion", "quattuordeciseptingentillion", "quindeciseptingentillion",
  "sedeciseptingentillion", "septendeciseptingentillion", "octodeciseptingentillion",
  "novendeciseptingentillion", "vigintiseptingentillion", "unvigintiseptingentillion",
  "duovigintiseptingentillion", "tresvigintiseptingentillion",
  "quattuorvigintiseptingentillion", "quinvigintiseptingentillion",
  "sesvigintiseptingentillion", "septemvigintiseptingentillion",
  "octovigintiseptingentillion", "novemvigintiseptingentillion",
  "trigintaseptingentillion", "untrigintaseptingentillion", "duotrigintaseptingentillion",
  "trestrigintaseptingentillion", "quattuortrigintaseptingentillion",
  "quintrigintaseptingentillion", "sestrigintaseptingentillion",
  "septentrigintaseptingentillion", "octotrigintaseptingentillion",
  "noventrigintaseptingentillion", "quadragintaseptingentillion",
  "unquadragintaseptingentillion", "duoquadragintaseptingentillion",
  "tresquadragintaseptingentillion", "quattuorquadragintaseptingentillion",
  "quinquadragintaseptingentillion", "sesquadragintaseptingentillion",
  "septenquadragintaseptingentillion", "octoquadragintaseptingentillion",
  "novenquadragintaseptingentillion", "quinquagintaseptingentillion",
  "unquinquagintaseptingentillion", "duoquinquagintaseptingentillion",
  "tresquinquagintaseptingentillion", "quattuorquinquagintaseptingentillion",
  "quinquinquagintaseptingentillion", "sesquinquagintaseptingentillion",
  "septenquinquagintaseptingentillion", "octoquinquagintaseptingentillion",
  "novenquinquagintaseptingentillion", "sexagintaseptingentillion",
  "unsexagintaseptingentillion", "duosexagintaseptingentillion",
  "tresexagintaseptingentillion", "quattuorsexagintaseptingentillion",
  "quinsexagintaseptingentillion", "sesexagintaseptingentillion",
  "septensexagintaseptingentillion", "octosexagintaseptingentillion",
  "novensexagintaseptingentillion", "septuagintaseptingentillion",
  "unseptuagintaseptingentillion", "duoseptuagintaseptingentillion",
  "treseptuagintaseptingentillion", "quattuorseptuagintaseptingentillion",
  "quinseptuagintaseptingentillion", "seseptuagintaseptingentillion",
  "septenseptuagintaseptingentillion", "octoseptuagintaseptingentillion",
  "novenseptuagintaseptingentillion", "octogintaseptingentillion",
  "unoctogintaseptingentillion", "duooctogintaseptingentillion",
  "tresoctogintaseptingentillion", "quattuoroctogintaseptingentillion",
  "quinoctogintaseptingentillion", "sexoctogintaseptingentillion",
  "septemoctogintaseptingentillion", "octooctogintaseptingentillion",
  "novemoctogintaseptingentillion", "nonagintaseptingentillion",
  "unnonagintaseptingentillion", "duononagintaseptingentillion",
  "trenonagintaseptingentillion", "quattuornonagintaseptingentillion",
  "quinnonagintaseptingentillion", "senonagintaseptingentillion",
  "septenonagintaseptingentillion", "octononagintaseptingentillion",
  "novenonagintaseptingentillion", "octingentillion", "unoctingentillion",
  "duooctingentillion", "tresoctingentillion", "quattuoroctingentillion",
  "quinoctingentillion", "sexoctingentillion", "septemoctingentillion",
  "octooctingentillion", "novemoctingentillion", "decioctingentillion",
  "undecioctingentillion", "duodecioctingentillion", "tredecioctingentillion",
  "quattuordecioctingentillion", "quindecioctingentillion", "sedecioctingentillion",
  "septendecioctingentillion", "octodecioctingentillion", "novendecioctingentillion",
  "vigintioctingentillion", "unvigintioctingentillion", "duovigintioctingentillion",
  "tresvigintioctingentillion", "quattuorvigintioctingentillion",
  "quinvigintioctingentillion", "sesvigintioctingentillion", "septemvigintioctingentillion",
  "octovigintioctingentillion", "novemvigintioctingentillion",
  "trigintaoctingentillion", "untrigintaoctingentillion", "duotrigintaoctingentillion",
  "trestrigintaoctingentillion", "quattuortrigintaoctingentillion",
  "quintrigintaoctingentillion", "sestrigintaoctingentillion",
  "septentrigintaoctingentillion", "octotrigintaoctingentillion",
  "noventrigintaoctingentillion", "quadragintaoctingentillion",
  "unquadragintaoctingentillion", "duoquadragintaoctingentillion",
  "tresquadragintaoctingentillion", "quattuorquadragintaoctingentillion",
  "quinquadragintaoctingentillion", "sesquadragintaoctingentillion",
  "septenquadragintaoctingentillion", "octoquadragintaoctingentillion",
  "novenquadragintaoctingentillion", "quinquagintaoctingentillion",
  "unquinquagintaoctingentillion", "duoquinquagintaoctingentillion",
  "tresquinquagintaoctingentillion", "quattuorquinquagintaoctingentillion",
  "quinquinquagintaoctingentillion", "sesquinquagintaoctingentillion",
  "septenquinquagintaoctingentillion", "octoquinquagintaoctingentillion",
  "novenquinquagintaoctingentillion", "sexagintaoctingentillion",
  "unsexagintaoctingentillion", "duosexagintaoctingentillion",
  "tresexagintaoctingentillion", "quattuorsexagintaoctingentillion",
  "quinsexagintaoctingentillion", "sesexagintaoctingentillion",
  "septensexagintaoctingentillion", "octosexagintaoctingentillion",
  "novensexagintaoctingentillion", "septuagintaoctingentillion",
  "unseptuagintaoctingentillion", "duoseptuagintaoctingentillion",
  "treseptuagintaoctingentillion", "quattuorseptuagintaoctingentillion",
  "quinseptuagintaoctingentillion", "seseptuagintaoctingentillion",
  "septenseptuagintaoctingentillion", "octoseptuagintaoctingentillion",
  "novenseptuagintaoctingentillion", "octogintaoctingentillion",
  "unoctogintaoctingentillion", "duooctogintaoctingentillion",
  "tresoctogintaoctingentillion", "quattuoroctogintaoctingentillion",
  "quinoctogintaoctingentillion", "sexoctogintaoctingentillion",
  "septemoctogintaoctingentillion", "octooctogintaoctingentillion",
  "novemoctogintaoctingentillion", "nonagintaoctingentillion",
  "unnonagintaoctingentillion", "duononagintaoctingentillion",
  "trenonagintaoctingentillion", "quattuornonagintaoctingentillion",
  "quinnonagintaoctingentillion", "senonagintaoctingentillion",
  "septenonagintaoctingentillion", "octononagintaoctingentillion",
  "novenonagintaoctingentillion", "nongentillion", "unnongentillion",
  "duonongentillion", "trenongentillion", "quattuornongentillion",
  "quinnongentillion", "senongentillion", "septenongentillion",
  "octonongentillion", "novenongentillion", "decinongentillion",
  "undecinongentillion", "duodecinongentillion", "tredecinongentillion",
  "quattuordecinongentillion", "quindecinongentillion", "sedecinongentillion",
  "septendecinongentillion", "octodecinongentillion", "novendecinongentillion",
  "vigintinongentillion", "unvigintinongentillion", "duovigintinongentillion",
  "tresvigintinongentillion", "quattuorvigintinongentillion", "quinvigintinongentillion",
  "sesvigintinongentillion", "septemvigintinongentillion", "octovigintinongentillion",
  "novemvigintinongentillion", "trigintanongentillion", "untrigintanongentillion",
  "duotrigintanongentillion", "trestrigintanongentillion", "quattuortrigintanongentillion",
  "quintrigintanongentillion", "sestrigintanongentillion", "septentrigintanongentillion",
  "octotrigintanongentillion", "noventrigintanongentillion", "quadragintanongentillion",
  "unquadragintanongentillion", "duoquadragintanongentillion",
  "tresquadragintanongentillion", "quattuorquadragintanongentillion",
  "quinquadragintanongentillion", "sesquadragintanongentillion",
  "septenquadragintanongentillion", "octoquadragintanongentillion",
  "novenquadragintanongentillion", "quinquagintanongentillion",
  "unquinquagintanongentillion", "duoquinquagintanongentillion",
  "tresquinquagintanongentillion", "quattuorquinquagintanongentillion",
  "quinquinquagintanongentillion", "sesquinquagintanongentillion",
  "septenquinquagintanongentillion", "octoquinquagintanongentillion",
  "novenquinquagintanongentillion", "sexagintanongentillion", "unsexagintanongentillion",
  "duosexagintanongentillion", "tresexagintanongentillion", "quattuorsexagintanongentillion",
  "quinsexagintanongentillion", "sesexagintanongentillion", "septensexagintanongentillion",
  "octosexagintanongentillion", "novensexagintanongentillion",
  "septuagintanongentillion", "unseptuagintanongentillion", "duoseptuagintanongentillion",
  "treseptuagintanongentillion", "quattuorseptuagintanongentillion",
  "quinseptuagintanongentillion", "seseptuagintanongentillion",
  "septenseptuagintanongentillion", "octoseptuagintanongentillion",
  "novenseptuagintanongentillion", "octogintanongentillion", "unoctogintanongentillion",
  "duooctogintanongentillion", "tresoctogintanongentillion", "quattuoroctogintanongentillion",
  "quinoctogintanongentillion", "sexoctogintanongentillion", "septemoctogintanongentillion",
  "octooctogintanongentillion", "novemoctogintanongentillion",
  "nonagintanongentillion", "unnonagintanongentillion", "duononagintanongentillion",
  "trenonagintanongentillion", "quattuornonagintanongentillion",
  "quinnonagintanongentillion", "senonagintanongentillion", "septenonagintanongentillion",
  "octononagintanongentillion", "novenonagintanongentillion"
)

# These are meant to work with `english_fractional()`. This provides nice names
# for fractions `x / y` for `x = 1:8`, `y = 1:9` (e.g. `1 / 2` -> "one half").
# We match these names to the output of `format_fractional()`, to account for
# different levels of precision. For example:
# - 1 digit precision:  `0.3`   -> "one third"
# - 2 digits precision: `0.33`  -> "one third", `0.3` -> "one tenth"
# - 3 digits precision: `0.333` -> "one third", `0.33` -> "thirty-three hundredths"
#
# The `one` argument should be `1` or `bignum::bigfloat(1)`, depending on whether
# we're formatting a numeric vector or a bigfloat
get_english_fractions <- function(one = 1) {
  fractionals <- c(
    1 / (one * 2),
    1:2 / (one * 3),
    c(1, 3) / (one * 4),
    1:4 / (one * 5),
    c(1, 5) / (one * 6),
    1:6 / (one * 7),
    c(1, 3, 5, 7) / (one * 8),
    one * c(1, 2, 4, 5, 7, 9) / (one * 9)
  )
  english_fractionals <- c(
    "one half", "one third", "two thirds", "one quarter", "three quarters",
    "one fifth", "two fifths", "three fifths", "four fifths", "one sixth",
     "five sixths", "one seventh", "two sevenths", "three sevenths",
     "four sevenths", "five sevenths", "six sevenths", "one eigth",
     "three eigths", "five eigths", "seven eigths", "one ninth", "two ninths",
     "four ninths", "five ninths", "seven ninths", "eight ninths"
  )

  # In some cases we won't have enough precision to represent a fraction, in
  # which case `formatted == ""` and we drop that from the english fractions.
  formatted <- format_fractional(fractionals)
  names(english_fractionals) <- formatted
  english_fractionals[formatted != ""]
}

# illions ----------------------------------------------------------------------

english_illions <- function(thousands_powers) {
  out <- character(length(thousands_powers))

  illions <- thousands_powers > 0
  out[illions] <- english_illions_recursive(thousands_powers[illions])
  out
}

english_illions_recursive <- function(thousands_powers) {
  out <- character(length(thousands_powers))

  zero_powers <- thousands_powers == 0
  if (all(zero_powers)) {
    return(out)
  }

  small <- !zero_powers & thousands_powers <= 1000
  large <- !(zero_powers | small)

  out[small] <- english_hundred_illions(thousands_powers[small])
  out[large] <- paste0(
    sub("on$", "", english_illions_recursive(((thousands_powers[large] - 1) %/% 1000) + 1)),
    english_hundred_nillions(((thousands_powers[large] - 1) %% 1000) + 1)
  )
  out
}

english_hundred_illions <- function(thousands_powers) {
  english$illions[thousands_powers]
}

english_hundred_nillions <- function(thousands_powers) {
  out <- english$illions[thousands_powers]
  out[thousands_powers == 1] <- "nillion"
  out
}

# tenillions -------------------------------------------------------------------

english_tenillions <- function(tens_power) {
  illions <- english_illions(tens_power %/% 3)
  trimws(paste(c("", "ten", "hundred")[(tens_power %% 3) + 1], illions))
}

# natural numbers --------------------------------------------------------------
# - `naturals` is expected to be a non-zero positive integer-ish number

# Covers naturals 1-999
english_hundreds <- function(naturals, suffix = "") {
  # `as.integer()` allows <bignum_biginteger> to be used as an index
  # - required because `letters[bignum::biginteger(1)]` is `NA` not "a"
  # - `naturals` is always going to be between 0-999, so no precision issues
  paste0(english$hundreds[as.integer(naturals + 1L)], suffix)
}

# Covers the natural numbers (excluding zero)
english_naturals <- function(naturals, and = FALSE, hyphenate = TRUE) {
  out <- english_naturals_recursive(
    naturals = naturals,
    prefixes = character(length(naturals)),
    iteration = 1L
  )
  after_format(trimws(out), and = and, hyphenate = hyphenate)
}

english_naturals_recursive <- function(naturals, prefixes, iteration) {

  nonzero_naturals <- naturals != 0
  if (!any(nonzero_naturals)) {
    return(prefixes)
  }

  # We're only going to add prefixes whenever the 100's are empty. Otherwise we
  # get `1,000,000` -> "one million thousand", but we just want "one million".
  hundreds <- get_hundreds(naturals[nonzero_naturals])
  nonzero_hundreds <- hundreds != 0

  prefixes[nonzero_naturals][nonzero_hundreds] <- paste(
    english_hundreds(
      naturals = hundreds[nonzero_hundreds],
      suffix = get_english_suffix(iteration)
    ),
    prefixes[nonzero_naturals][nonzero_hundreds]
  )
  naturals <- consume_hundreds(naturals)
  english_naturals_recursive(naturals, prefixes, iteration = iteration + 1L)
}

get_english_suffix <- function(iteration) {
  if (iteration > length(english$suffixes)) {
    # When `iteration == 2L` we're at the thousands place, whereas
    # `english_illions(2L)` is a "million".
    paste0(" ", english_illions(iteration - 1L)) # nocov
  } else {
    english$suffixes[iteration]
  }
}

# This will raise warnings about precision issues for large numbers, which is
# now what we want since we can steer users towards {bignum} if they need more
# precision. E.g. try `get_hundreds(100^100)`.
get_hundreds <- function(naturals) {
  naturals %% 1000L
}

consume_hundreds <- function(naturals) {
  naturals %/% 1000L
}

# fractional numbers -----------------------------------------------------------
# - `fractional_characters` is the output of `format_fractional(<numeric>)`
#   where <numeric> is in range (0, 1)
# - `doubles` is expected to be a non-zero positive numeric

english_fractionals <- function(fractionals, ...) {
  UseMethod("english_fractionals")
}

# Covers numbers in range (0, 1)
english_fractionals.numeric <- function(
    fractionals,
    zero = "zero",
    and = FALSE,
    hyphenate = TRUE,
    english_fractions = get_english_fractions(1),
    ...
  ) {

  out <- character(length(fractionals))

  # The number of "english" decimal places is dependent on the number of decimals
  # shown by `format_fractional()` (as called by `format_number()`). This ensures
  # that "what you see is what you get".
  fractional_characters <- format_fractional(fractionals)
  n_decimals <- nchar(fractional_characters)

  # `zeros` occur when we don't have precision to represent small `fractionals`
  zeros <- n_decimals == 0
  nices <- fractional_characters %in% names(english_fractions)

  out[zeros] <- zero
  out[nices] <- english_fractions[fractional_characters[nices]]

  if (all(zeros | nices)) {
    return(out)
  }

  fracs <- !zeros & !nices

  # `format_fractional()` gives us the trailing digits (e.g. 0.0123 -> "0123")
  # so we can coerce this to numeric to get the natural number representation.
  natural_fracs <- as.double(fractional_characters[fracs])

  # NOTE: We may have to trim leading zeros if they cause an issue
  # natural_fracs <- as.double(sub("^0+", "", fractional_characters[fracs]))

  out[fracs] <- paste0(
    english_naturals(natural_fracs, and = and, hyphenate = hyphenate),
    " ",
    if (hyphenate) sub(" ", "-", english_tenillions(n_decimals[fracs])) else english_tenillions(n_decimals[fracs]),
    # "one thousandth" for "0.001" vs. "two thousandths" for "0.002"
    ifelse(grepl("^0*1$", fractional_characters[fracs]), "th", "ths")
  )
  out
}

english_fractionals.bignum_bigfloat <- function(
    fractionals,
    zero = "zero",
    and = FALSE,
    hyphenate = TRUE,
    english_fractions = get_english_fractions(bignum::bigfloat("1")),
    ...
  ) {

  out <- character(length(fractionals))

  # The number of "english" decimal places is dependent on the number of decimals
  # shown by `format_fractional()` (as called by `format_number()`). This ensures
  # that "what you see is what you get".
  fractional_characters <- format_fractional(fractionals)
  n_decimals <- nchar(fractional_characters)

  # `zeros` occur when we don't have enough precision to represent small `fractionals`
  zeros <- n_decimals == 0
  nices <- fractional_characters %in% names(english_fractions)

  out[zeros] <- zero
  out[nices] <- english_fractions[fractional_characters[nices]]

  if (all(zeros | nices)) {
    return(out)
  }

  fracs <- !zeros & !nices

  # `format_fractional()` gives us the trailing digits (e.g. 0.0123 -> "0123")
  # so we can give them to the `bignum::biginteger(<character>)` constructor
  natural_fracs <- bignum::biginteger(fractional_characters[fracs])

  # NOTE: We may have to trim leading zeros if they cause an issue
  # natural_fracs <- bignum::biginteger(sub("^0+", "", fractional_characters[fracs]))

  out[fracs] <- paste0(
    english_naturals(natural_fracs, and = and, hyphenate = hyphenate),
    " ",
    if (hyphenate) sub(" ", "-", english_tenillions(n_decimals[fracs])) else english_tenillions(n_decimals[fracs]),
    # "one thousandth" for "0.001" vs. "two thousandths" for "0.002"
    ifelse(grepl("(0|\\.)1$", fractional_characters[fracs]), "th", "ths")
  )
  out
}

# formatters -------------------------------------------------------------------
# - `english_naturals` is the output of `english_naturals()`

# Controls all post-englishification formatting of the natural numbers
after_format <- function(english_naturals, and = FALSE, hyphenate = TRUE) {
  if (and) english_naturals <- andify(english_naturals)
  if (!hyphenate) english_naturals <- unhypenate(english_naturals)
  english_naturals
}

# Add an "and" before the last number if in 1:99 (e.g. "one thousand and one"
# and not "one thousand and one hundred")
andify <- function(english_naturals) {
  last_number <- sub(".*\\s", "", english_naturals)
  needs_an_and <- last_number %in% english$hundreds[1:99 + 1]

  english_naturals[needs_an_and] <- sub(
    pattern = "^(.*) (\\S+)$",
    replacement =  "\\1 and \\2",
    x = english_naturals[needs_an_and]
  )
  english_naturals
}

unhypenate <- function(english_naturals) {
  sub("-", " ", english_naturals)
}
