% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nth-friendly.R
\name{nth_friendly}
\alias{nth_friendly}
\alias{nth_friendly_safe}
\title{Translate integer-ish numbers to a character vector of nths (1st, 2nd, 3rd)}
\usage{
nth_friendly(
  numbers,
  zero = "0th",
  na = "missingth",
  nan = "not a numberth",
  inf = "infinitieth",
  negative = "negative ",
  bigmark = TRUE
)

nth_friendly_safe(
  numbers,
  zero = "zeroth",
  na = "missingth",
  nan = "not a numberth",
  inf = "infinitieth",
  negative = "negative ",
  bigmark = TRUE
)
}
\arguments{
\item{numbers}{\verb{[integer / numeric]}

An integer or integer-ish numeric vector to translate.}

\item{zero}{\verb{[character(1)]}

What to call values of \code{0} in \code{numbers} (e.g. \code{zero = "zero"}).}

\item{na}{\verb{[character(1)]}

What to call values of \code{NA} in \code{numbers} (e.g. \code{na = "missing"}).}

\item{nan}{\verb{[character(1)]}

What to call values of \code{NaN} in \code{numbers} (e.g. \code{nan = "undefined"}).}

\item{inf}{\verb{[character(1)]}

What to call values of \code{Inf} in \code{numbers} (e.g. \code{inf = "infinity"}).}

\item{negative}{\verb{[character(1)]}

A prefix added to the translation of negative elements of \code{numbers}.
\code{negative} is the string \code{"negative "} by default.}

\item{bigmark}{\verb{[TRUE / FALSE]}

Whether the thousands places of formatted numbers should be separated with
a comma (e.g. \code{"10,000,000"} vs. \code{"10000000"}). \code{bigmark} is \code{TRUE} by
default.}
}
\value{
A non-NA character vector of the same length as \code{numbers}.
}
\description{
Convert an integer vector, or numeric vector which is coercible to an integer
without loss of precision, to an "nth" (e.g. 1st, 2nd, 3rd, 22nd, 1,000th).

\code{nth_friendly_safe()} checks that all arguments are of the correct type
and raises an informative error otherwise. \code{nth_friendly()} does not
perform input validation to maximize its speed.
}
\examples{
nth_friendly(c(0, 1, 2, 3, 22, 1001, NA, NaN, Inf, -Inf))

# Specify the translations of "special" numbers
nth_friendly(c(1, 0, NA), zero = "noneth", na = "?")

# Use `bigmark` to add or remove commas
nth_friendly(1234, bigmark = TRUE)
nth_friendly(1234, bigmark = FALSE)

# Input validation
try(nth_friendly_safe(1234, bigmark = ","))
}
