% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quantifier-friendly.R
\name{quantifier_friendly}
\alias{quantifier_friendly}
\alias{quantifier_friendly_safe}
\title{Translate integer-ish numbers to a character vector of quantifiers (the, both, all three)}
\usage{
quantifier_friendly(
  numbers,
  one = "the",
  two = "both",
  zero = "no",
  na = "a missing",
  nan = "an undefined",
  inf = "every",
  negative = "negative ",
  and = FALSE,
  hyphenate = TRUE,
  bigmark = TRUE,
  max_friendly = 100
)

quantifier_friendly_safe(
  numbers,
  one = "the",
  two = "both",
  zero = "no",
  na = "a missing",
  nan = "an undefined",
  inf = "every",
  negative = "negative ",
  and = FALSE,
  hyphenate = TRUE,
  bigmark = TRUE,
  max_friendly = 100
)
}
\arguments{
\item{numbers}{\verb{[integer / numeric]}

An integer or integer-ish numeric vector to translate.}

\item{one}{\verb{[character(1)]}

What to call values of \code{1} in \code{numbers} (e.g. \code{one = "the"}).}

\item{two}{\verb{[character(1)]}

What to call values of \code{2} in \code{numbers} (e.g. \code{two = "both"}).}

\item{zero}{\verb{[character(1)]}

What to call values of \code{0} in \code{numbers} (e.g. \code{zero = "zero"}).}

\item{na}{\verb{[character(1)]}

What to call values of \code{NA} in \code{numbers} (e.g. \code{na = "missing"}).}

\item{nan}{\verb{[character(1)]}

What to call values of \code{NaN} in \code{numbers} (e.g. \code{nan = "undefined"}).}

\item{inf}{\verb{[character(1)]}

What to call values of \code{Inf} in \code{numbers} (e.g. \code{inf = "infinity"}).}

\item{negative}{\verb{[character(1)]}

A prefix added to the translation of negative elements of \code{numbers}.
\code{negative} is the string \code{"negative "} by default.}

\item{and}{\verb{[TRUE / FALSE]}

Whether to insert an \code{" and "} before the tens place of translated \code{numbers}.
\code{and} is \code{FALSE} by default.}

\item{hyphenate}{\verb{[TRUE / FALSE]}

Whether to hyphenate numbers 21 through 99 (e.g. \code{"twenty-one"} vs. \code{"twenty one"}).
\code{hyphenate} is \code{TRUE} by default.}

\item{bigmark}{\verb{[TRUE / FALSE]}

Whether the thousands places of formatted numbers should be separated with
a comma (e.g. \code{"10,000,000"} vs. \code{"10000000"}). \code{bigmark} is \code{TRUE} by
default.}

\item{max_friendly}{\verb{[numeric]}

The maximum number to convert to a numeral. Elements of \code{numbers} above
\code{max_friendly} are converted to formatted numbers (e.g. \code{"all 1,000"}
instead of \code{"all one thousand"}). \code{max_friendly} is \code{100} by default.

Use the \code{bigmark} argument to determine whether these formatted numbers
are comma separated (e.g. \code{"all 1,000"} vs. \code{"all 1000"}).}
}
\value{
A non-NA character vector of the same length as \code{numbers}.
}
\description{
Convert an integer vector, or numeric vector which is coercible to an integer
without loss of precision, to a quantifier (e.g. no, the, every, all five).

\code{quantifier_friendly_safe()} checks that all arguments are of the correct type
and raises an informative error otherwise. \code{quantifier_friendly()} does not
perform input validation to maximize its speed.
}
\examples{
quantifier_friendly(c(0, 1, 2, 3, NA, NaN, Inf))

# The `negative` prefix appears after the `"all"` prefix
quantifier_friendly(-4)

# `-1` and `-2` are not translated using `one` and `two`
quantifier_friendly(c(1, 2, -1, -2), one = "the", two = "both")

# Suppress the translation of large numbers
quantifier_friendly(c(99, 1234), max_friendly = -Inf)
quantifier_friendly(c(99, 1234), max_friendly = 100)
quantifier_friendly(c(99, 1234), max_friendly = 1500)

# Specify the translations of "special" numbers
quantifier_friendly(c(1, Inf), one = "a", inf = "all")

# Arguments `one`, `two`, `inf`, etc. take precedence over `max_friendly`
quantifier_friendly(1:3, one = "one", two = "two", max_friendly = -1)

# Modify the output formatting
quantifier_friendly(1021, max_friendly = Inf)
quantifier_friendly(1021, and = TRUE, max_friendly = Inf)
quantifier_friendly(1021, hyphenate = FALSE, max_friendly = Inf)
quantifier_friendly(1021, bigmark = FALSE, max_friendly = 10)
quantifier_friendly(1021, bigmark = TRUE, max_friendly = 10)

# Input validation
try(quantifier_friendly_safe(1234, max_friendly = NA))
}
