% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vis_surface_background.R
\name{collayer.bg}
\alias{collayer.bg}
\title{Compute binarized mean curvature surface color layer.}
\usage{
collayer.bg(subjects_dir, subject_id, bg, hemi = "both")
}
\arguments{
\item{subjects_dir}{character string, the FreeSurfer SUBJECTS_DIR.}

\item{subject_id}{character string, the subject identifier.}

\item{bg}{character string, a background name. One of 'curv', 'curv_light', 'sulc', 'sulc_light', or 'aparc'.  If this is already a colorlayer in a hemilist, it will be returned as-is.}

\item{hemi}{character string, one of 'lh', 'rh', or 'both'. The latter will merge the data for both hemis into a single vector.}
}
\value{
a color layer, i.e., vector of color strings in a hemilist
}
\description{
Compute a binarized mean curvature surface color layer, this is intended as a background color layer. You can merge it with your data layer using \code{\link[fsbrain]{collayers.merge}}.
}
\seealso{
You can plot the return value using \code{\link[fsbrain]{vis.color.on.subject}}.

Other surface color layer: 
\code{\link{collayer.bg.atlas}()},
\code{\link{collayer.bg.meancurv}()},
\code{\link{collayer.bg.sulc}()},
\code{\link{collayer.from.annot}()},
\code{\link{collayer.from.annotdata}()},
\code{\link{collayer.from.mask.data}()},
\code{\link{collayer.from.morphlike.data}()},
\code{\link{collayers.merge}()}
}
\concept{surface color layer}
