
#' Frequencies of the American and European HGDP populations
#'
#' \code{Freq} is a data.frame containing the frequencies of 49,636 markers located on chromosome 1, 
#' for the 13 American and European populations described in the Stanford HGDP dataset. 
#'  
#' @format A data.frame
#'
"Freq"

#' Number of gametes of the American and European HGDP populations
#'
#' \code{NbGamete} is a data.frame containing the number of gametes collected 
#' for the 13 American and European populations described in the Stanford HGDP dataset. 
#'  
#' @format A data.frame
#'
"NbGamete"

#' Marker information
#'
#' \code{Info} is a data.frame describing the markers located on chromosome 1 in the Stanford 
#' HGDP dataset. Each row corresponds to a marker, and the 5 columns provide information about
#' the marker name, its chromosome membership, its position, and its reference and alternative alleles. 
#' 
#' 
#' @format A data.frame
#'
"Info"
