% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readss2Dir.R
\name{readss2Dir}
\alias{readss2Dir}
\title{Read ss2 predicted Directory (readss2Dir)}
\usage{
readss2Dir(dirPath)
}
\arguments{
\item{dirPath}{The path of the directory which contains all predss2 files. Each file belongs to a sequence.}
}
\value{
returns a list of vectors with all the predicted secondary structure for each amino acid. The length of the
list is the number of files(sequences) and the length of each vector is (length sequence(i))
}
\description{
This function reads a directory that contains the output files of PSIPRED
It gets the directory path as the input and returns a list of vectors. Each vector contains the secondary structure of the amino acids in a peptide/protein sequence.
}
\examples{


PredSS2dir<-system.file("testForder",package="ftrCOOL")
PredSS2dir<-paste0(PredSS2dir,"/ss2Dir/")
listPredVect<-readss2Dir(PredSS2dir)

}
