% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auc_boot.R
\name{auc_boot}
\alias{auc_boot}
\title{Bootstrap AUCs}
\usage{
auc_boot(
  data,
  group = NULL,
  nboot = 1000,
  byDR = FALSE,
  ca_adj = FALSE,
  lsize = 6,
  csize = 3
)
}
\arguments{
\item{data}{A data frame or matrix saving both cp and ca frequencies. cp must precede ca.}

\item{group}{A vector indicating group membership. Will calculate AUCs by group.}

\item{nboot}{Number of bootstrap iterations for each group. Defaults to 1,000.}

\item{byDR}{Whether to order ids by diagnosticity ratios. Defaults to FALSE.}

\item{ca_adj}{Whether to adjust id rates for ca lineups \emph{after} simulating a sample from the unadjusted rates.}

\item{lsize}{Size of lineup (used to adjust id rates). Defaults to 6.}

\item{csize}{Number of confidence levels (used to adjust id rates). Defaults to 3.}
}
\value{
A list with simulated AUCs.
}
\description{
A function to simulate bootstrap samples and calculate AUC.
}
\examples{
cpf <- c(100, 90, 80, 20, 10, 5)
caf <- c(6, 7, 15, 50, 75, 120)
auc_boot(cbind(cpf, caf), nboot = 100)

}
