% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fusionLegend.R
\name{fusionLegend}
\alias{fusionLegend}
\title{Adding FusionCharts legend}
\usage{
fusionLegend(
  fusionPlot,
  showLegend = TRUE,
  interactiveLegend = TRUE,
  legendPosition = c("bottom", "left", "right"),
  legendAllowDrag = FALSE,
  legendIconScale = "1",
  reverseLegend = FALSE,
  legendCaption = "",
  legendCaptionBold = TRUE,
  legendCaptionFont = "Arial",
  legendCaptionFontSize = "14",
  legendCaptionFontColor = "#333333"
)
}
\arguments{
\item{fusionPlot}{fusionPlot object got by \code{fusionPlot()}}

\item{showLegend}{Show the legend}

\item{interactiveLegend}{Enable interactive legend}

\item{legendPosition}{Specify the position of the legend}

\item{legendAllowDrag}{Make the legend draggable}

\item{legendIconScale}{Specify the legend icon size (values from "1" to "5")}

\item{reverseLegend}{Reverse the order of datasets}

\item{legendCaption}{Specify the legend caption value}

\item{legendCaptionBold}{Set the legend caption font style to bold}

\item{legendCaptionFont}{Specify the legend caption font}

\item{legendCaptionFontSize}{Specify the legend caption font size}

\item{legendCaptionFontColor}{Specify the hex color code for the caption font legend}
}
\description{
\url{https://www.fusioncharts.com/dev/chart-guide/chart-configurations/legend}
}
\examples{
library(fusionchartsR)
df <- data.frame(label = c("Venezuela", "Saudi", "Canada", "Russia"), value = c(290, 260, 180, 115))
df \%>\%
  fusionPlot(x = "label", y = "value", type = "doughnut2d") \%>\%
  fusionLegend(legendCaption = "LegendCaption", legendCaptionFontSize = "24") \%>\%
  fusionTheme(theme = "fusion")

}
