% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fusionMultiPlot.R
\name{fusionMultiPlot}
\alias{fusionMultiPlot}
\title{Create new multiple charts}
\usage{
fusionMultiPlot(data, x, y, col, type = "msstepline", numberSuffix = NULL)
}
\arguments{
\item{data}{Default dataset to use}

\item{x, y}{character name of variable}

\item{col}{define seriesname variable}

\item{type}{type of chart}

\item{numberSuffix}{Specify the suffix for all the Y-axis values on the chart}
}
\description{
Main function to make interactive charts.
Check all charts at \url{https://www.fusioncharts.com/charts}
}
\examples{
library(fusionchartsR)

# Multiple charts
new.data <- data.frame(
label = rep(x = c(2012:2016), times = 2),
seriesname = c(rep("iOS App Store", 5), rep("Google Play Store", 5)),
values = c(1:10)
)

new.data \%>\%
fusionMultiPlot(
x = "label",
y = "values",
col = "seriesname",
type = "mscolumn2d",
) \%>\%
fusionTheme(theme = "fusion")

}
