% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggfusionPlot.R
\name{ggfusionPlot}
\alias{ggfusionPlot}
\title{Convert a ggplot2 object to a fusionchartsR object.}
\usage{
ggfusionPlot(object)
}
\arguments{
\item{object}{a ggplot object}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\examples{
library(ggplot2)
library(fusionchartsR)

df <- data.frame(
  label = rep(x = c(2012:2016), times = 2),
  seriesname = c(rep("iOS App Store", 5), rep("Google Play Store", 5)),
  values = c(1:10)
)

object <- ggplot(df, aes(label, values, fill = seriesname)) +
  geom_col()

ggfusionPlot(object)
}
