% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/behaviors.R
\name{click_select}
\alias{click_select}
\title{Configure Click Select Behavior}
\usage{
click_select(
  key = "click-select",
  animation = TRUE,
  degree = 0,
  enable = TRUE,
  multiple = FALSE,
  state = c("selected", "active", "inactive", "disabled", "highlight"),
  neighborState = c("selected", "active", "inactive", "disabled", "highlight"),
  unselectedState = NULL,
  onClick = NULL,
  trigger = "shift",
  ...
)
}
\arguments{
\item{key}{Behavior unique identifier. Useful to modify this behavior from JS side.}

\item{animation}{Whether to enable animation effects when switching element states (boolean, default: TRUE).}

\item{degree}{Controls the highlight spread range (number or function, default: 0).}

\item{enable}{Whether to enable the click element function (boolean or function, default: TRUE).}

\item{multiple}{Whether to allow multiple selections (boolean, default: FALSE).}

\item{state}{The state applied when an element is selected (string, default: "selected").}

\item{neighborState}{The state applied to elements with n-degree relationships (string, default: "selected").}

\item{unselectedState}{The state applied to all other elements (string, default: NULL).}

\item{onClick}{Callback when an element is clicked (function, default: NULL).}

\item{trigger}{Keys for multi-selection (character vector, default: c("shift")).}

\item{...}{Extra parameters. See \url{https://g6.antv.antgroup.com/en/manual/behavior/click-select}.}
}
\value{
A list with the configuration settings for the click select behavior.
}
\description{
Creates a configuration object for the click-select behavior in G6.
This allows users to select graph elements by clicking.
}
\examples{
# Basic configuration
config <- click_select()

# Custom configuration
config <- click_select(
  animation = FALSE,
  degree = 1,
  multiple = TRUE,
  state = "active",
  neighborState = "highlight",
  unselectedState = "inactive",
  trigger = c("Control")
)

# Example leveraging the input[["<GRAPH_ID>-selected_<ELEMENT_TYPE>"]]
if (interactive()) {
  library(shiny)
  library(g6R)
  library(bslib)

  nodes <- data.frame(id = c("node1", "node2"))
  edges <- data.frame(source = "node1", target = "node2")
  combos <- data.frame(id = "combo1", type = "rect")

  ui <- page_fluid(
    g6_output("graph"),
    verbatimTextOutput("selected_elements")
  )

  server <- function(input, output, session) {
    output$graph <- render_g6({
      g6(
        nodes = nodes,
        edges = edges,
        combos = combos
      ) |>
        g6_layout() |>
        g6_behaviors(
          click_select(multiple = TRUE),
          brush_select(
            enableElements = c("node", "edge", "combo"),
            immediately = TRUE
          )
        )
    })

    output$selected_elements <- renderPrint({
      list(
        selected_nodes = input[["graph-selected_node"]],
        selected_edges = input[["graph-selected_edge"]],
        selected_combos = input[["graph-selected_combo"]]
      )
    })
  }

  shinyApp(ui, server)
}
}
