% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/behaviors.R
\name{scroll_canvas}
\alias{scroll_canvas}
\title{Configure Scroll Canvas Behavior}
\usage{
scroll_canvas(
  key = "scroll-canvas",
  enable = TRUE,
  direction = NULL,
  range = 1,
  sensitivity = 1,
  trigger = NULL,
  onFinish = NULL,
  preventDefault = TRUE,
  ...
)
}
\arguments{
\item{key}{Unique identifier for the behavior (string, default: "scroll-canvas").}

\item{enable}{Whether to enable this behavior (boolean or JS function, default: TRUE).}

\item{direction}{Allowed scrolling direction: "x", "y", or NULL for no limit
(string or NULL, default: NULL).}

\item{range}{Scrollable viewport range in viewport size units (numeric or numeric vector, default: 1).}

\item{sensitivity}{Scrolling sensitivity, the larger the value, the faster the scrolling
(numeric, default: 1).}

\item{trigger}{Keyboard shortcuts to trigger scrolling (list, default: NULL).}

\item{onFinish}{Callback function when scrolling is finished (JS function, default: NULL).}

\item{preventDefault}{Whether to prevent the browser's default event (boolean, default: TRUE).}

\item{...}{Extra parameters. See \url{https://g6.antv.antgroup.com/en/manual/behavior/scroll-canvas}.}
}
\value{
A list with the configuration settings for the scroll-canvas behavior.
}
\description{
Creates a configuration object for the scroll-canvas behavior in G6.
This behavior allows scrolling the canvas with mouse wheel or keyboard.
}
\examples{
# Basic configuration
config <- scroll_canvas()

# Custom configuration
config <- scroll_canvas(
  key = "my-scroll-behavior",
  direction = "x",
  range = c(-2, 2),
  sensitivity = 1.5,
  preventDefault = FALSE
)

# With keyboard triggers and callback
config <- scroll_canvas(
  enable = JS("(event) => !event.altKey"),
  trigger = list(
    up = "w",
    down = "s",
    left = "a",
    right = "d"
  ),
  onFinish = JS("() => { console.log('Scrolling finished'); }")
)
}
