% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xbar_r_varcomps.R
\name{xbar_varcomps}
\alias{xbar_varcomps}
\title{Average and Range Method Variance Component Summary}
\usage{
xbar_varcomps(data, part, operator, meas)
}
\arguments{
\item{data}{An R dataframe or tibble.}

\item{part}{Column name (unquoted) specifying the unique ID of the part being measured.}

\item{operator}{Column name (unquoted) specifying the operator for the recorded measurement.}

\item{meas}{Column name (unquoted) where the measurement value is recorded.}
}
\value{
A list of numeric values for repeatability, reproducibility, total GRR, part-to-part, and total variance components.
}
\description{
Average and Range Method Variance Component Summary
}
\examples{
data <- data.frame(
  SN = rep(c("SerialNumber_01","SerialNumber_02"), each = 4),
  Operator = rep(c("Operator_01","Operator_02"), each = 2, times = 2),
  Measure = c(0.0172,0.0177,0.0155,0.0159,0.0174,0.0181,0.0152,0.0176)
)
xbar_varcomps(data, part = 'SN', operator = 'Operator', meas = 'Measure')
}
