% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collect_media.R
\name{collect_media}
\alias{collect_media}
\title{Collect media files}
\usage{
collect_media(df, thumbnail = FALSE, path)
}
\arguments{
\item{df}{A \code{tibble} returned by \code{atlas_media()} or a pipe starting with
\code{request_data(type = "media")}.}

\item{thumbnail}{Default is \code{FALSE}. If \code{TRUE} will download small
thumbnail-sized images, rather than full size images (default).}

\item{path}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}
Use \verb{galah_config(directory = "path-to-directory)"} instead. Supply a path
to a local folder/directory where downloaded media will be saved to.}
}
\value{
Invisibly returns a \code{tibble} listing the number of files downloaded,
grouped by their HTML status codes. Primarily called for the side effect of
downloading available image & media files to a user local directory.
}
\description{
This function downloads full-sized or thumbnail images and media files
to a local directory using information from \code{\link[=atlas_media]{atlas_media()}}
}
\examples{
\dontrun{
# Use `atlas_media()` to return a `tibble` of records that contain media
x <- galah_call() |> 
  identify("perameles") |>
  filter(year == 2015) |>
  atlas_media()

# To download media files, add `collect_media()` to the end of a query 
galah_config(directory = "media_files")
collect_media(x)

# Since version 2.0, it is possible to run all steps in sequence
# first, get occurrences, making sure to include media fields:
occurrences_df <- request_data() |>
  identify("Regent Honeyeater") |>
  filter(!is.na(images), year == 2011) |>
  select(group = "media") |>
  collect()
 
# second, get media metadata
media_info <- request_metadata() |>
  filter(media == occurrences_df) |>
  collect()
  
# the two steps above + `right_join()` are synonymous with `atlas_media()`
# third, get images
request_files() |>
  filter(media == media_info) |>
  collect(thumbnail = TRUE)
# step three is synonymous with `collect_media()`
}
}
