% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_zip.R
\name{read_zip}
\alias{read_zip}
\title{Read downloaded data from a zip file}
\usage{
read_zip(file)
}
\arguments{
\item{file}{(character) A file name. Must be a length-1 character ending in
\code{.zip}.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Living atlases supply data downloads as zip files. This function reads these
data efficiently, i.e. without unzipping them first, using the \code{readr}
package. Although this function has been part of galah for some time, it was
previously internal to \code{\link[=atlas_occurrences]{atlas_occurrences()}}. It has been exported now to
support easy re-importing of downloaded files, without the need to re-run
a query.
}
\examples{
\dontrun{
# set a working directory
galah_config(directory = "data-raw",
             email = "an-email-address@email.com")

# download some data
galah_call() |>
  identify("Heleioporus") |>
  filter(year == 2022) |>
  collect(file = "burrowing_frog_data.zip")
  
# load data from file
x <- read_zip("./data-raw/burrowing_frog_data.zip")
}
}
