% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dplyr-arrange.R
\name{arrange.data_request}
\alias{arrange.data_request}
\alias{arrange.metadata_request}
\title{Order rows using column values}
\usage{
\method{arrange}{data_request}(.data, ...)

\method{arrange}{metadata_request}(.data, ...)
}
\arguments{
\item{.data}{An object of class \code{data_request}}

\item{...}{A variable to arrange the resulting tibble by. Should be one of
the variables also listed in \code{\link[=group_by.data_request]{group_by()}}.}
}
\value{
An amended \code{data_request} with a completed \code{arrange} slot.
}
\description{
\code{arrange.data_request()} arranges rows of a query on the server side, meaning
that the query is constructed in such a way that information will be arranged
when the query is processed. This only has an effect when used in combination
with \code{\link[=count.data_request]{count()}} and
\code{\link[=group_by.data_request]{group_by()}}. The benefit of using
\code{arrange()} within a \code{galah_call()} pipe is that it is sometimes beneficial
to choose a non-default order for data to be delivered in, particularly if
\code{\link[=slice_head.data_request]{slice_head()}} is also called.
}
\examples{
\dontrun{

# Arrange grouped counts by ascending year
galah_call() |>
  identify("Crinia") |>
  filter(year >= 2020) |>
  group_by(year) |>
  arrange(year) |>
  count() |>
  collect()
  
# Arrange grouped counts by ascending record count
galah_call() |>
  identify("Crinia") |>
  filter(year >= 2020) |>
  group_by(year) |>
  arrange(count) |>
  count() |>
  collect()

# Arrange grouped counts by descending year
galah_call() |>
  identify("Crinia") |>
  filter(year >= 2020) |>
  group_by(year) |>
  arrange(desc(year)) |>
  count() |>
  collect()
}
}
