% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/capture.R
\name{capture.data_request}
\alias{capture.data_request}
\alias{capture}
\alias{capture.metadata_request}
\alias{capture.files_request}
\alias{capture.list}
\title{Capture a request}
\usage{
capture(x, ...)

\method{capture}{data_request}(x, mint_doi = FALSE, ...)

\method{capture}{metadata_request}(x, ...)

\method{capture}{files_request}(x, thumbnail = FALSE, ...)

\method{capture}{list}(x, ...)
}
\arguments{
\item{x}{A \verb{_request} object to convert to a \code{prequery}.}

\item{...}{Other arguments, currently ignored}

\item{mint_doi}{Logical: should a DOI be minted for this download? Only
applies to \code{type = "occurrences"} when atlas chosen is "ALA".}

\item{thumbnail}{Logical: should thumbnail-size images be returned? Defaults
to \code{FALSE}, indicating full-size images are required.}
}
\value{
Either an object of class \code{prequery} when further processing is
required; or \code{query} when it is not. Both classes are structurally identical,
being list-like and containing at the following slots:
\itemize{
\item \code{type}: The type of query, serves as a lookup to the corresponding field in \code{show_all(apis)}
\item \code{url}: Either:
\itemize{
\item a length-1 character giving the API to be queried; or
\item a \code{tibble()} containing at least the field \code{url} and optionally others
}
\item \code{request}: captures the preceeding \verb{_request} object (see \code{\link[=galah_call]{galah_call()}})
}
}
\description{
The first step in evaluating a request is to capture and parse the
information it contains. The resulting object has class \code{prequery}
for those requiring further processing or \code{query} for those that don't.
A \code{prequery} object shows the basic structure of what has been requested by
a user in a given \code{\link[=galah_call]{galah_call()}}.
}
\details{
\code{galah} uses an object-based pipeline to convert piped requests into
valid queries, and to enact those queries with the specified organisation.
Typically, requests open with \code{\link[=galah_call]{galah_call()}} - though \code{\link[=request_metadata]{request_metadata()}}
and \code{\link[=request_files]{request_files()}} are also valid - and end with
\code{\link[=collect.data_request]{collect()}}. Under the hood,
the sequence of functions is as follows:

\code{\link[=capture]{capture()}} → \code{\link[=compound]{compound()}} →
\code{\link[=collapse.data_request]{collapse()}} →
\code{\link[=compute.data_request]{compute()}} →
\code{\link[=collect.data_request]{collect()}}

\code{\link[=capture]{capture()}} is the first of the \code{\link[=galah_call]{galah_call()}} workflow, and it parses the
basic structure of a user request, returned as a \code{prequery} object.
A \code{prequery} object shows what has been requested, before those
calls are built by \code{\link[=compound]{compound()}} and evaluated by
\code{\link[=collapse.data_request]{collapse()}}.
For simple cases, this gives the same result as running
\code{\link[=collapse.data_request]{collapse()}} while the \code{run_checks}
argument of \code{\link[=galah_config]{galah_config()}} is set to \code{FALSE}, but is slightly faster.
In complex cases, it is simply a precursor to \code{\link[=compound]{compound()}}.
}
\seealso{
To open a piped query, see \code{\link[=galah_call]{galah_call()}}. For alternative
operations on \verb{_request} objects, see \code{\link[=compound]{compound()}},
\code{\link[=collapse.data_request]{collapse()}},
\code{\link[=compute.data_request]{compute()}} or
\code{\link[=collect.data_request]{collect()}}.
}
