% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chebspec.R
\name{chebspec}
\alias{chebspec}
\title{Create Chebyshev spectral differentiation matrix}
\usage{
chebspec(n, k = NULL)
}
\arguments{
\item{n}{order of the matrix.}

\item{k}{\code{k=0} is the default, no boundary conditions. The matrix is similar to a Jordan block
of size \code{n} with eigenvalue 0. If \code{k=1}, the matrix is nonsingular
and well-conditioned, and its eigenvalues have negative real parts.}
}
\value{
Chebyshev spectral differentiation matrix
}
\description{
Chebyshev spectral differentiation matrix of order \code{n}. \code{k} determines
  the character of the output matrix. For either form, the eigenvector matrix is ill-conditioned.
}
