% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main_distr.R
\name{distr_score}
\alias{distr_score}
\title{Compute Score}
\usage{
distr_score(y, f, distr, param = NULL, par_link = NULL, scaling = NULL)
}
\arguments{
\item{y}{Observations. For an univariate distribution, a numeric vector. For a multivariate distribution, a numeric matrix with observations in rows or a numeric vector of a single observation.}

\item{f}{Parameters. For the same parameters for all observations, a numeric vector. For individual parameters for each observation, a numeric matrix with rows corresponding to observations.}

\item{distr}{A distribution.}

\item{param}{A parametrization of the distribution.}

\item{par_link}{An optional logical vector indicating whether the logarithmic/logistic link should be applied to restricted parameters in order to obtain unrestricted values. Defaults to keeping the original link for all parameters.}

\item{scaling}{An optional scaling function for the score. The supported scaling functions are the unit scaling (\code{scaling = "unit"}), the inverse of the Fisher information matrix scaling (\code{scaling = "fisher_inv"}), and the inverse square root of the Fisher information matrix scaling (\code{scaling = "fisher_inv_sqrt"}).}
}
\value{
The (scaled) score.
}
\description{
A function computing score or scaled score for a given distribution.
}
\examples{
# Score for the negative binomial distribution
distr_score(y = c(1, 8, 5, 0, 0), f = c(13.50, 0.03), distr = "negbin")

}
\seealso{
\code{\link[gasmodel:distr]{distr()}}
}
