% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gc_scale.R
\name{gc_scale}
\alias{gc_scale}
\title{Scale Gene-Cluster Coordinates for Visualization}
\usage{
gc_scale(GC_meta = GC_meta, levels_gene_group = levels_gene_group)
}
\arguments{
\item{GC_meta}{A data frame containing gene-cluster information.  Must include
the columns \code{gene_cluster}, \code{gene_group}, \code{gene_label},
\code{start}, \code{end}, and \code{direction} (numeric: \code{1}
for forward, \code{-1} for reverse).}

\item{levels_gene_group}{Character vector specifying the desired factor levels
for \code{gene_group}.  Group names should
appear in the order required for plotting legends.}
}
\value{
The input data frame with the following \strong{new or overwritten} columns:
\describe{
\item{\code{gene_label}}{Empty string (\code{""}) if originally \code{NA}.}
\item{\code{gene_group}}{Set to \code{"hypothetical ORF"} if originally
\code{NA}, then coerced to a factor using
\code{levels_gene_group}.}
\item{\code{Pgenome}}{Factor version of \code{gene_cluster}; levels
follow the order of appearance in the data.}
\item{\code{Pstart}, \code{Pend}}{Relative start and end coordinates
(numeric) within each cluster,
scaled so that the left-most gene
starts at 0.}
\item{\code{Pdirection}}{Logical vector: \code{TRUE} for forward,
\code{FALSE} for reverse.}
}
}
\description{
Prepares a gene‐cluster annotation table for downstream plotting by
converting absolute genomic coordinates into relative positions,
ensuring that every cluster starts at 0 and is oriented consistently.
Hypothetical ORFs (originally labeled with \code{NA}) and missing
labels are replaced with placeholders, and factor levels are set
as requested.
}
\details{
\itemize{
\item Absolute \code{start}/\code{end} values are \strong{not} modified; scaled
values are stored in new columns (\code{Pstart}, \code{Pend}).
\item \code{Pgenome} can be swapped for any unique identifier (e.g., \code{Genome})
downstream if each genome contains only one cluster.
}
}
