% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{CentroidFunctions}
\alias{CentroidFunctions}
\alias{centroid}
\alias{centroid_x}
\alias{centroid_y}
\alias{centroid_both}
\title{Calculate centroid}
\usage{
centroid(
  x,
  y,
  return,
  xlim = NULL,
  blank = 0,
  subset = NULL,
  na.rm = TRUE,
  neg.rm = FALSE,
  warn_xlim_out_of_range = TRUE,
  warn_negative_y = TRUE
)

centroid_x(x, y, return = "x", ...)

centroid_y(x, y, return = "y", ...)

centroid_both(x, y, return = "both", ...)
}
\arguments{
\item{x}{Numeric vector of x values}

\item{y}{Numeric vector of y values}

\item{return}{One of c("x", "y", "both"), determining whether the function
will return the x value of the centroid, the y value
of the centroid, or a vector containing x then y}

\item{xlim}{Vector, of length 2, delimiting the x range over which the
centroid should be calculated (where NA can be
provided for the area to be calculated from the start or to
the end of the data)}

\item{blank}{Value to be subtracted from \code{y} values before calculating
the centroid}

\item{subset}{A vector of logical values indicating which x and y values
should be included (TRUE) or excluded (FALSE).}

\item{na.rm}{a logical indicating whether missing values should be removed}

\item{neg.rm}{a logical indicating whether \code{y} values below zero should 
be treated as zeros. If \code{FALSE}, the centroid
for negative \code{y} values will be calculated normally,
effectively pulling the centroid towards the x axis.}

\item{warn_xlim_out_of_range}{logical whether warning should be issued when 
xlim is lower than the lowest x value or higher
than the highest x value.}

\item{warn_negative_y}{logical whether warning should be issued when 
\code{neg.rm == FALSE} but some y values are below 0.}

\item{...}{Other arguments to pass to \code{centroid}}
}
\value{
A scalar for the x value (if \code{return = 'x'}) or
        y value (if \code{return = 'y'}) of the centroid of the data
}
\description{
This function takes a vector of \code{x} and \code{y} values
and returns the x and/or y position of the centroid of mass of the
area under the curve
}
\details{
This function uses \link[sf]{st_centroid} to calculate the centroid of mass
}
