% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{predict_interpolation}
\alias{predict_interpolation}
\title{Predict data by linear interpolation from existing data}
\usage{
predict_interpolation(
  x,
  y,
  newdata,
  extrapolate_predictions = TRUE,
  na.rm = TRUE
)
}
\arguments{
\item{x}{A vector of known predictor values.}

\item{y}{A vector of known response values.}

\item{newdata}{A vector of new predictor values for which the response
value will be predicted}

\item{extrapolate_predictions}{Boolean indicating whether values of \code{newdata} that are 
out of the domain of \code{x} should be predicted (by 
extrapolating the slope from the endpoints of \code{x}). If
\code{FALSE}, such values will be returned as \code{NA}.}

\item{na.rm}{logical whether NA's should be removed before making predictions}
}
\value{
A vector of response values for each predictor value in 
        \code{newdata}
}
\description{
Predict data by linear interpolation from existing data
}
