% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{trans_wide_to_tidy}
\alias{trans_wide_to_tidy}
\title{Pivot wide-shaped into tidy}
\usage{
trans_wide_to_tidy(
  wides,
  data_cols = NA,
  id_cols = NA,
  names_to = "Well",
  values_to = "Measurements",
  values_to_numeric = TRUE,
  ...
)
}
\arguments{
\item{wides}{A single wide-shaped dataframe, or a list of wide-shaped
dataframe's}

\item{data_cols, id_cols}{Specifies which columns have data vs are ID's
(in \link[tidyr]{pivot_longer} parlance). Each can be
a single vector (which will be applied for all
dataframes) or a list of vectors, with each
vector corresponding to the same-index dataframe
in \code{wides}

Entries that are NA in the list will not be used

If neither \code{data_cols} nor \code{id_cols} are 
specified, user must provide arguments to 
\link[tidyr]{pivot_longer} via \code{...} for at 
least the \code{cols} argument and these arguments 
provided via \code{...} will be used for all 
\code{wides} dataframe's}

\item{names_to, values_to}{Specifies the output column names created by
\link[tidyr]{pivot_longer}. Each can be provided 
as vectors the same length as \code{wides}}

\item{values_to_numeric}{logical indicating whether values will be coerced
to numeric. See below for when this may be
overridden by arguments passed in \code{...}}

\item{...}{Other arguments to be passed to \link[tidyr]{pivot_longer}
Note that including \code{values_transform} here will override the
behavior of \code{values_to_numeric}}
}
\value{
Pivoted longer dataframe (if \code{wides} is a single dataframe)
        or list of pivoted longer dataframes (if \code{wides} is
        a list of dataframes)
}
\description{
Essentially a wrapper for \link[tidyr]{pivot_longer} that works on both a 
single wide-shaped dataframe as well as a list of wide-shaped dataframe's
}
